/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ListExpression
extends Expression {
    public Expression[] expressions;
    public Constant optimizedBooleanConstant;

    public ListExpression(Expression expression1, Expression expression2) {
        if (expression1 instanceof ListExpression) {
            ListExpression expr1 = (ListExpression)expression1;
            this.expressions = new Expression[expr1.expressions.length + 1];
            System.arraycopy(expr1.expressions, 0, this.expressions, 0, expr1.expressions.length);
            this.expressions[this.expressions.length - 1] = expression2;
        } else {
            this.expressions = new Expression[]{expression1, expression2};
        }
        this.sourceStart = this.expressions[0].sourceStart;
        this.sourceEnd = this.expressions[this.expressions.length - 1].sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        int i = 0;
        while (i < this.expressions.length) {
            this.expressions[i].checkNPE(currentScope, flowContext, flowInfo);
            flowInfo = this.expressions[i].analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
            ++i;
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
    }

    public boolean isCompactableOperation() {
        return true;
    }

    public TypeBinding resolveType(BlockScope scope) {
        int i = 0;
        while (i < this.expressions.length) {
            this.resolvedType = this.expressions[i].resolveType(scope);
            ++i;
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            int i = 0;
            while (i < this.expressions.length) {
                this.expressions[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        int i = 0;
        while (i < this.expressions.length) {
            if (i > 0) {
                output.append(", ");
            }
            this.expressions[i].printExpression(indent, output);
            ++i;
        }
        return output;
    }
}

