/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;

public class ObjectLiteral
extends Expression {
    public ObjectLiteralField[] fields;

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.fields == null || this.fields.length == 0) {
            output.append("{}");
        } else {
            output.append("{\n");
            ObjectLiteral.printIndent(indent + 1, output);
            int i = 0;
            while (i < this.fields.length) {
                if (i > 0) {
                    output.append(",\n");
                    ObjectLiteral.printIndent(indent + 1, output);
                }
                this.fields[i].printExpression(indent, output);
                ++i;
            }
            output.append("\n");
            ObjectLiteral.printIndent(indent, output);
            output.append("}");
        }
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope) && this.fields != null) {
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i].traverse(visitor, scope);
                ++i;
            }
        }
        visitor.endVisit(this, scope);
    }

    public TypeBinding resolveType(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.fields != null) {
            int i = 0;
            while (i < this.fields.length) {
                this.fields[i].resolveType(scope);
                ++i;
            }
        }
        return TypeBinding.ANY;
    }

    public int nullStatus(FlowInfo flowInfo) {
        return -1;
    }

    public FlowInfo analyseCode(BlockScope classScope, FlowContext initializationContext, FlowInfo flowInfo) {
        if (this.fields != null) {
            int i = 0;
            while (i < this.fields.length) {
                flowInfo = this.fields[i].analyseCode(classScope, initializationContext, flowInfo);
                ++i;
            }
        }
        return flowInfo;
    }
}

