/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.CastExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.Wildcard;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;

public class QualifiedAllocationExpression
extends AllocationExpression {
    public Expression enclosingInstance;
    public TypeDeclaration anonymousType;
    public ReferenceBinding superTypeBinding;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(TypeDeclaration anonymousType) {
        this.anonymousType = anonymousType;
        anonymousType.allocation = this;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(currentScope, flowContext, flowInfo);
        }
        ReferenceBinding allocatedType = this.superTypeBinding == null ? this.binding.declaringClass : this.superTypeBinding;
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)allocatedType.erasure(), currentScope, flowInfo);
        if (this.arguments != null) {
            int i = 0;
            int count = this.arguments.length;
            while (i < count) {
                flowInfo = this.arguments[i].analyseCode(currentScope, flowContext, flowInfo);
                ++i;
            }
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(currentScope, flowContext, flowInfo);
        }
        TypeBinding[] thrownExceptions = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(thrownExceptions, (ASTNode)this, (FlowInfo)flowInfo.unconditionalCopy(), currentScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(currentScope, flowInfo);
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
        boolean isUnboxing;
        int pc = codeStream.position;
        ReferenceBinding allocatedType = this.codegenBinding.declaringClass;
        codeStream.new_(allocatedType);
        boolean bl = isUnboxing = (this.implicitConversion & 0x400) != 0;
        if (valueRequired || isUnboxing) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(pc, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(currentScope, allocatedType, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, currentScope, codeStream);
        if (allocatedType.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(currentScope, allocatedType, this);
        }
        if (this.syntheticAccessor == null) {
            codeStream.invokespecial(this.codegenBinding);
        } else {
            int i = 0;
            int max = this.syntheticAccessor.parameters.length - this.codegenBinding.parameters.length;
            while (i < max) {
                codeStream.aconst_null();
                ++i;
            }
            codeStream.invokespecial(this.syntheticAccessor);
        }
        if (valueRequired) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else if (isUnboxing) {
            codeStream.generateImplicitConversion(this.implicitConversion);
            switch (this.postConversionType((Scope)currentScope).id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(pc, this.sourceStart);
        if (this.anonymousType != null) {
            this.anonymousType.generateCode(currentScope, codeStream);
        }
    }

    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        ReferenceBinding allocatedTypeErasure;
        if ((flowInfo.tagBits & 1) == 0 && (allocatedTypeErasure = (ReferenceBinding)this.binding.declaringClass.erasure()).isNestedType() && currentScope.enclosingSourceType().isLocalType()) {
            if (allocatedTypeErasure.isLocalType()) {
                ((LocalTypeBinding)allocatedTypeErasure).addInnerEmulationDependent(currentScope, this.enclosingInstance != null);
            } else {
                currentScope.propagateInnerEmulation(allocatedTypeErasure, this.enclosingInstance != null);
            }
        }
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        if (this.enclosingInstance != null) {
            this.enclosingInstance.printExpression(0, output).append('.');
        }
        super.printExpression(0, output);
        if (this.anonymousType != null) {
            this.anonymousType.print(indent, output);
        }
        return output;
    }

    public TypeBinding resolveType(BlockScope scope) {
        MethodBinding inheritedBinding;
        boolean argsContainCast;
        boolean hasError;
        TypeBinding receiverType;
        TypeBinding enclosingInstanceType;
        block49: {
            block47: {
                boolean enclosingInstanceContainsCast;
                block51: {
                    block50: {
                        block48: {
                            if (this.anonymousType == null && this.enclosingInstance == null) {
                                return super.resolveType(scope);
                            }
                            this.constant = Constant.NotAConstant;
                            enclosingInstanceType = null;
                            receiverType = null;
                            hasError = false;
                            enclosingInstanceContainsCast = false;
                            argsContainCast = false;
                            if (this.enclosingInstance == null) break block47;
                            if (this.enclosingInstance instanceof CastExpression) {
                                this.enclosingInstance.bits |= 0x20;
                                enclosingInstanceContainsCast = true;
                            }
                            if ((enclosingInstanceType = this.enclosingInstance.resolveType(scope)) != null) break block48;
                            hasError = true;
                            break block49;
                        }
                        if (!enclosingInstanceType.isBaseType() && !enclosingInstanceType.isArrayType()) break block50;
                        scope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(enclosingInstanceType, this.enclosingInstance);
                        hasError = true;
                        break block49;
                    }
                    if (!(this.type instanceof QualifiedTypeReference)) break block51;
                    scope.problemReporter().illegalUsageOfQualifiedTypeReference((QualifiedTypeReference)this.type);
                    hasError = true;
                    break block49;
                }
                receiverType = ((SingleTypeReference)this.type).resolveTypeEnclosing(scope, (ReferenceBinding)enclosingInstanceType);
                if (receiverType == null || !enclosingInstanceContainsCast) break block49;
                CastExpression.checkNeedForEnclosingInstanceCast(scope, this.enclosingInstance, enclosingInstanceType, receiverType);
                break block49;
            }
            if (this.type == null) {
                receiverType = scope.enclosingSourceType();
            } else {
                receiverType = this.type.resolveType(scope, true);
                if (receiverType != null && this.type instanceof ParameterizedQualifiedTypeReference) {
                    ReferenceBinding currentType = (ReferenceBinding)receiverType;
                    block0: while ((currentType.modifiers & 8) == 0 && !currentType.isRawType()) {
                        if ((currentType = currentType.enclosingType()) != null) continue;
                        ParameterizedQualifiedTypeReference qRef = (ParameterizedQualifiedTypeReference)this.type;
                        int i = qRef.typeArguments.length - 2;
                        while (i >= 0) {
                            if (qRef.typeArguments[i] != null) {
                                scope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, receiverType);
                                break block0;
                            }
                            --i;
                        }
                        break block0;
                    }
                }
            }
        }
        if (receiverType == null) {
            hasError = true;
        } else if (((ReferenceBinding)receiverType).isFinal()) {
            if (this.anonymousType != null) {
                if (!receiverType.isEnum()) {
                    scope.problemReporter().anonymousClassCannotExtendFinalClass(this.type, receiverType);
                    hasError = true;
                }
            } else if (!receiverType.canBeInstantiated()) {
                scope.problemReporter().cannotInstantiate(this.type, receiverType);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
        }
        if (this.typeArguments != null) {
            int length = this.typeArguments.length;
            this.genericTypeArguments = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                TypeReference typeReference = this.typeArguments[i];
                TypeBinding argType = typeReference.resolveType(scope, true);
                if (argType == null) {
                    if (typeReference instanceof Wildcard) {
                        scope.problemReporter().illegalUsageOfWildcard(typeReference);
                    }
                    return null;
                }
                this.genericTypeArguments[i] = argType;
                ++i;
            }
        }
        TypeBinding[] argumentTypes = Binding.NO_PARAMETERS;
        if (this.arguments != null) {
            int length = this.arguments.length;
            argumentTypes = new TypeBinding[length];
            int i = 0;
            while (i < length) {
                Expression argument = this.arguments[i];
                if (argument instanceof CastExpression) {
                    argument.bits |= 0x20;
                    argsContainCast = true;
                }
                if ((argumentTypes[i] = argument.resolveType(scope)) == null) {
                    hasError = true;
                }
                ++i;
            }
        }
        if (hasError) {
            if (receiverType instanceof ReferenceBinding) {
                MethodBinding closestMatch;
                int length = this.arguments == null ? 0 : this.arguments.length;
                TypeBinding[] pseudoArgs = new TypeBinding[length];
                int i = length;
                while (--i >= 0) {
                    TypeBinding typeBinding = pseudoArgs[i] = argumentTypes[i] == null ? TypeBinding.NULL : argumentTypes[i];
                }
                this.binding = scope.findMethod((ReferenceBinding)receiverType, TypeConstants.INIT, pseudoArgs, this);
                if (this.binding != null && !this.binding.isValidBinding() && (closestMatch = ((ProblemMethodBinding)this.binding).closestMatch) != null) {
                    if (closestMatch.original().typeVariables != Binding.NO_TYPE_VARIABLES) {
                        closestMatch = scope.environment().createParameterizedGenericMethod(closestMatch.original(), (RawTypeBinding)null);
                    }
                    this.binding = closestMatch;
                    MethodBinding closestMatchOriginal = closestMatch.original();
                    if ((closestMatchOriginal.isPrivate() || closestMatchOriginal.declaringClass.isLocalType()) && !scope.isDefinedInMethod(closestMatchOriginal)) {
                        closestMatchOriginal.modifiers |= 0x8000000;
                    }
                }
            }
            this.resolvedType = receiverType;
            return this.resolvedType;
        }
        if (this.anonymousType == null) {
            if (!receiverType.canBeInstantiated()) {
                scope.problemReporter().cannotInstantiate(this.type, receiverType);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            ReferenceBinding allocationType = (ReferenceBinding)receiverType;
            this.binding = scope.getConstructor(allocationType, argumentTypes, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, scope, true)) {
                    scope.problemReporter().deprecatedMethod(this.binding, this);
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = allocationType;
                }
                scope.problemReporter().invalidConstructor(this, this.binding);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            QualifiedAllocationExpression.checkInvocationArguments(scope, null, allocationType, this.binding, this.arguments, argumentTypes, argsContainCast, this);
            ReferenceBinding expectedType = this.binding.declaringClass.enclosingType();
            if (expectedType != enclosingInstanceType) {
                scope.compilationUnitScope().recordTypeConversion(expectedType, enclosingInstanceType);
            }
            if (enclosingInstanceType.isCompatibleWith(expectedType) || scope.isBoxingCompatibleWith(enclosingInstanceType, expectedType)) {
                this.enclosingInstance.computeConversion(scope, expectedType, enclosingInstanceType);
                this.resolvedType = receiverType;
                return this.resolvedType;
            }
            scope.problemReporter().typeMismatchError(enclosingInstanceType, expectedType, this.enclosingInstance);
            this.resolvedType = receiverType;
            return this.resolvedType;
        }
        if (receiverType.isTypeVariable()) {
            receiverType = new ProblemReferenceBinding(receiverType.sourceName(), (ReferenceBinding)receiverType, 9);
            scope.problemReporter().invalidType(this, receiverType);
            return null;
        }
        if (this.type != null && receiverType.isEnum()) {
            scope.problemReporter().cannotInstantiate(this.type, receiverType);
            this.resolvedType = receiverType;
            return this.resolvedType;
        }
        this.superTypeBinding = receiverType.isInterface() ? scope.getJavaLangObject() : (ReferenceBinding)receiverType;
        scope.addAnonymousType(this.anonymousType, (ReferenceBinding)receiverType);
        this.anonymousType.resolve(scope);
        if (this.superTypeBinding.erasure().id == 41) {
            scope.problemReporter().cannotExtendEnum(this.anonymousType.binding, this.type, this.superTypeBinding);
        }
        if ((receiverType.tagBits & 0x40000000L) != 0L) {
            scope.problemReporter().superTypeCannotUseWildcard(this.anonymousType.binding, this.type, receiverType);
        }
        if (!(inheritedBinding = scope.getConstructor(this.superTypeBinding, argumentTypes, this)).isValidBinding()) {
            if (inheritedBinding.declaringClass == null) {
                inheritedBinding.declaringClass = this.superTypeBinding;
            }
            scope.problemReporter().invalidConstructor(this, inheritedBinding);
            this.resolvedType = this.anonymousType.binding;
            return this.resolvedType;
        }
        if (this.enclosingInstance != null) {
            ReferenceBinding targetEnclosing = inheritedBinding.declaringClass.enclosingType();
            if (targetEnclosing == null) {
                scope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.enclosingInstance, (ReferenceBinding)receiverType);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            if (!enclosingInstanceType.isCompatibleWith(targetEnclosing) && !scope.isBoxingCompatibleWith(enclosingInstanceType, targetEnclosing)) {
                scope.problemReporter().typeMismatchError(enclosingInstanceType, targetEnclosing, this.enclosingInstance);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            this.enclosingInstance.computeConversion(scope, targetEnclosing, enclosingInstanceType);
        }
        if (this.arguments != null) {
            QualifiedAllocationExpression.checkInvocationArguments(scope, null, this.superTypeBinding, inheritedBinding, this.arguments, argumentTypes, argsContainCast, this);
        }
        this.binding = this.anonymousType.createDefaultConstructorWithBinding(inheritedBinding);
        this.resolvedType = this.anonymousType.binding;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(visitor, scope);
            }
            if (this.typeArguments != null) {
                int i = 0;
                int typeArgumentsLength = this.typeArguments.length;
                while (i < typeArgumentsLength) {
                    this.typeArguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.type != null) {
                this.type.traverse(visitor, scope);
            }
            if (this.arguments != null) {
                int argumentsLength = this.arguments.length;
                int i = 0;
                while (i < argumentsLength) {
                    this.arguments[i].traverse(visitor, scope);
                    ++i;
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

