/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompoundAssignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.OperatorIds;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemFieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;

public class SingleNameReference
extends NameReference
implements OperatorIds {
    public static final int READ = 0;
    public static final int WRITE = 1;
    public char[] token;

    public SingleNameReference(char[] source, long pos) {
        this.token = source;
        this.sourceStart = (int)(pos >>> 32);
        this.sourceEnd = (int)pos;
    }

    public FlowInfo analyseAssignment(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, Assignment assignment, boolean isCompound) {
        FieldBinding fieldBinding;
        boolean isReachable;
        boolean bl = isReachable = (flowInfo.tagBits & 1) == 0;
        if (isCompound) {
            switch (this.bits & 0xF) {
                case 1: {
                    fieldBinding = (FieldBinding)this.binding;
                    if (fieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(fieldBinding) && !flowInfo.isDefinitelyAssigned(fieldBinding)) {
                        currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                    }
                    this.manageSyntheticAccessIfNecessary(currentScope, flowInfo, true);
                    break;
                }
                case 2: {
                    LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                    if (!flowInfo.isDefinitelyAssigned(localBinding)) {
                        currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                    }
                    if (isReachable) {
                        localBinding.useFlag = 1;
                        break;
                    }
                    if (localBinding.useFlag != 0) break;
                    localBinding.useFlag = 2;
                }
            }
        }
        if (assignment.expression != null) {
            flowInfo = assignment.expression.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        }
        switch (this.bits & 0xF) {
            case 1: {
                this.manageSyntheticAccessIfNecessary(currentScope, flowInfo, false);
                fieldBinding = (FieldBinding)this.binding;
                ReferenceBinding declaringClass = fieldBinding.declaringClass;
                if (declaringClass.isEnum()) {
                    MethodScope methodScope = currentScope.methodScope();
                    SourceTypeBinding sourceType = currentScope.enclosingSourceType();
                    if (fieldBinding.isStatic() && this.constant == Constant.NotAConstant && !methodScope.isStatic && (sourceType == declaringClass || sourceType.superclass == declaringClass) && methodScope.isInsideInitializerOrConstructor()) {
                        currentScope.problemReporter().enumStaticFieldUsedDuringInitialization(fieldBinding, this);
                    }
                }
                if (!fieldBinding.isFinal()) break;
                if (!isCompound && fieldBinding.isBlankFinal() && currentScope.allowBlankFinalFieldAssignment(fieldBinding)) {
                    if (flowInfo.isPotentiallyAssigned(fieldBinding)) {
                        currentScope.problemReporter().duplicateInitializationOfBlankFinalField(fieldBinding, this);
                    } else {
                        flowContext.recordSettingFinal(fieldBinding, this, flowInfo);
                    }
                    flowInfo.markAsDefinitelyAssigned(fieldBinding);
                    break;
                }
                currentScope.problemReporter().cannotAssignToFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                this.bits = !flowInfo.isDefinitelyAssigned(localBinding) ? (this.bits |= 8) : (this.bits &= 0xFFFFFFF7);
                if (localBinding.isFinal()) {
                    if ((this.bits & 0x1FE0) == 0) {
                        if (isReachable && isCompound || !localBinding.isBlankFinal()) {
                            currentScope.problemReporter().cannotAssignToFinalLocal(localBinding, this);
                        } else if (flowInfo.isPotentiallyAssigned(localBinding)) {
                            currentScope.problemReporter().duplicateInitializationOfFinalLocal(localBinding, this);
                        } else {
                            flowContext.recordSettingFinal(localBinding, this, flowInfo);
                        }
                    } else {
                        currentScope.problemReporter().cannotAssignToFinalOuterLocal(localBinding, this);
                    }
                } else if ((localBinding.tagBits & 0x400L) != 0L) {
                    currentScope.problemReporter().parameterAssignment(localBinding, this);
                }
                flowInfo.markAsDefinitelyAssigned(localBinding);
            }
        }
        this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.analyseCode(currentScope, flowContext, flowInfo, true);
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo, boolean valueRequired) {
        switch (this.bits & 0xF) {
            case 1: {
                if (valueRequired) {
                    this.manageSyntheticAccessIfNecessary(currentScope, flowInfo, true);
                }
                FieldBinding fieldBinding = (FieldBinding)this.binding;
                ReferenceBinding declaringClass = fieldBinding.declaringClass;
                if (declaringClass.isEnum()) {
                    MethodScope methodScope = currentScope.methodScope();
                    SourceTypeBinding sourceType = currentScope.enclosingSourceType();
                    if (fieldBinding.isStatic() && this.constant == Constant.NotAConstant && !methodScope.isStatic && (sourceType == declaringClass || sourceType.superclass == declaringClass) && methodScope.isInsideInitializerOrConstructor()) {
                        currentScope.problemReporter().enumStaticFieldUsedDuringInitialization(fieldBinding, this);
                    }
                }
                if (!fieldBinding.isBlankFinal() || !currentScope.allowBlankFinalFieldAssignment(fieldBinding) || flowInfo.isDefinitelyAssigned(fieldBinding)) break;
                currentScope.problemReporter().uninitializedBlankFinalField(fieldBinding, this);
                break;
            }
            case 2: {
                LocalVariableBinding localBinding = (LocalVariableBinding)this.binding;
                if (localBinding.isSameCompilationUnit(currentScope) && !flowInfo.isDefinitelyAssigned(localBinding)) {
                    currentScope.problemReporter().uninitializedLocalVariable(localBinding, this);
                }
                if ((flowInfo.tagBits & 1) == 0) {
                    localBinding.useFlag = 1;
                    break;
                }
                if (localBinding.useFlag != 0) break;
                localBinding.useFlag = 2;
            }
        }
        if (valueRequired) {
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
        }
        return flowInfo;
    }

    public TypeBinding checkFieldAccess(BlockScope scope) {
        FieldBinding fieldBinding = (FieldBinding)this.binding;
        this.bits &= 0xFFFFFFF0;
        this.bits |= 1;
        MethodScope methodScope = scope.methodScope();
        boolean isStatic = fieldBinding.isStatic();
        if (!isStatic && methodScope != null && methodScope.isStatic) {
            scope.problemReporter().staticFieldAccessToNonStaticVariable(this, fieldBinding);
            this.constant = Constant.NotAConstant;
            return fieldBinding.type;
        }
        this.constant = fieldBinding.constant();
        if (this.isFieldUseDeprecated(fieldBinding, scope, (this.bits & 0x2000) != 0)) {
            scope.problemReporter().deprecatedField(fieldBinding, this);
        }
        return fieldBinding.type;
    }

    public void computeConversion(Scope scope, TypeBinding runtimeTimeType, TypeBinding compileTimeType) {
    }

    public void generateAssignment(BlockScope currentScope, CodeStream codeStream, Assignment assignment, boolean valueRequired) {
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream, boolean valueRequired) {
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
    }

    public void generateCompoundAssignment(BlockScope currentScope, CodeStream codeStream, MethodBinding writeAccessor, Expression expression, int operator, int assignmentImplicitConversion, boolean valueRequired) {
    }

    public void generatePostIncrement(BlockScope currentScope, CodeStream codeStream, CompoundAssignment postIncrement, boolean valueRequired) {
    }

    public TypeBinding[] genericTypeArguments() {
        return null;
    }

    public LocalVariableBinding localVariableBinding() {
        switch (this.bits & 0xF) {
            case 1: {
                break;
            }
            case 2: {
                return (LocalVariableBinding)this.binding;
            }
        }
        return null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            if ((this.bits & 0x1FE0) == 0 || this.constant != Constant.NotAConstant) {
                return;
            }
            if ((this.bits & 0xF) == 2) {
                currentScope.emulateOuterAccess((LocalVariableBinding)this.binding);
            }
        }
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo, boolean isReadAccess) {
    }

    public int nullStatus(FlowInfo flowInfo) {
        if (this.constant != null && this.constant != Constant.NotAConstant) {
            return -1;
        }
        switch (this.bits & 0xF) {
            case 1: {
                return 0;
            }
            case 2: {
                LocalVariableBinding local = (LocalVariableBinding)this.binding;
                if (local == null) break;
                if (flowInfo.isDefinitelyNull(local)) {
                    return 1;
                }
                if (flowInfo.isDefinitelyNonNull(local)) {
                    return -1;
                }
                return 0;
            }
        }
        return -1;
    }

    public TypeBinding postConversionType(Scope scope) {
        TypeBinding convertedType = this.resolvedType;
        int runtimeType = (this.implicitConversion & 0xFF) >> 4;
        switch (runtimeType) {
            case 5: {
                convertedType = TypeBinding.BOOLEAN;
                break;
            }
            case 3: {
                convertedType = TypeBinding.BYTE;
                break;
            }
            case 4: {
                convertedType = TypeBinding.SHORT;
                break;
            }
            case 2: {
                convertedType = TypeBinding.CHAR;
                break;
            }
            case 10: {
                convertedType = TypeBinding.INT;
                break;
            }
            case 9: {
                convertedType = TypeBinding.FLOAT;
                break;
            }
            case 7: {
                convertedType = TypeBinding.LONG;
                break;
            }
            case 8: {
                convertedType = TypeBinding.DOUBLE;
            }
        }
        if ((this.implicitConversion & 0x200) != 0) {
            convertedType = scope.environment().computeBoxingType(convertedType);
        }
        return convertedType;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        return output.append(this.token);
    }

    public TypeBinding reportError(BlockScope scope) {
        this.constant = Constant.NotAConstant;
        if (this.binding instanceof ProblemFieldBinding) {
            scope.problemReporter().invalidField(this, (FieldBinding)this.binding);
        } else if (this.binding instanceof ProblemReferenceBinding) {
            scope.problemReporter().invalidType(this, (TypeBinding)this.binding);
        } else {
            scope.problemReporter().unresolvableReference(this, this.binding);
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope) {
        return this.resolveType(scope, false, null);
    }

    public TypeBinding resolveType(BlockScope scope, boolean define, TypeBinding useType) {
        this.constant = Constant.NotAConstant;
        if (this.actualReceiverType != null) {
            this.binding = scope.getField(this.actualReceiverType, this.token, this);
        } else {
            this.actualReceiverType = scope.enclosingSourceType();
            this.binding = scope.getBinding(this.token, (0xC | this.bits) & 0xF, (InvocationSite)this, true);
        }
        if (define && this.binding instanceof ProblemBinding) {
            LocalDeclaration localDeclaration = new LocalDeclaration(this.token, this.sourceEnd, this.sourceEnd);
            LocalVariableBinding localBinding = new LocalVariableBinding(localDeclaration, (TypeBinding)TypeBinding.UNKNOWN, 0, false);
            localBinding.setConstant(Constant.NotAConstant);
            scope.compilationUnitScope().addLocalVariable(localBinding);
            this.binding = localBinding;
        }
        if (this.binding.isValidBinding()) {
            switch (this.bits & 0xF) {
                case 1: 
                case 2: 
                case 3: 
                case 7: {
                    if (this.binding instanceof VariableBinding) {
                        VariableBinding variable = (VariableBinding)this.binding;
                        if (this.binding instanceof LocalVariableBinding) {
                            this.bits &= 0xFFFFFFF0;
                            this.bits |= 2;
                            TypeBinding fieldType = variable.type;
                            if (useType != null && useType.id != 12) {
                                if (fieldType == TypeBinding.UNKNOWN) {
                                    fieldType = variable.type = useType;
                                } else if (!fieldType.isCompatibleWith(useType)) {
                                    fieldType = variable.type = TypeBinding.ANY;
                                }
                            }
                            if ((this.bits & 0x2000) == 0) {
                                this.constant = variable.constant();
                                if (fieldType != null) {
                                    fieldType = fieldType.capture(scope, this.sourceEnd);
                                }
                            } else {
                                this.constant = Constant.NotAConstant;
                            }
                            this.resolvedType = fieldType;
                            return this.resolvedType;
                        }
                        FieldBinding field = (FieldBinding)this.binding;
                        if (!field.isStatic() && scope.compilerOptions().getSeverity(0x400000L) != -1) {
                            scope.problemReporter().unqualifiedFieldAccess(this, field);
                        }
                        TypeBinding fieldType = this.checkFieldAccess(scope);
                        this.resolvedType = (this.bits & 0x2000) == 0 ? fieldType.capture(scope, this.sourceEnd) : fieldType;
                        return this.resolvedType;
                    }
                    if (this.binding instanceof MethodBinding) {
                        return scope.getJavaLangFunction();
                    }
                    this.bits &= 0xFFFFFFF0;
                    this.bits |= 4;
                }
                case 4: {
                    this.constant = Constant.NotAConstant;
                    TypeBinding type = (TypeBinding)this.binding;
                    if (this.isTypeUseDeprecated(type, scope)) {
                        scope.problemReporter().deprecatedType(type, this);
                    }
                    this.resolvedType = type = scope.environment().convertToRawType(type);
                    return this.resolvedType;
                }
            }
        }
        this.resolvedType = this.reportError(scope);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public void traverse(ASTVisitor visitor, ClassScope scope) {
        visitor.visit(this, scope);
        visitor.endVisit(this, scope);
    }

    public String unboundReferenceErrorName() {
        return new String(this.token);
    }
}

