/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.ast;

import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Statement;
import org.eclipse.wst.jsdt.internal.compiler.codegen.CodeStream;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowContext;
import org.eclipse.wst.jsdt.internal.compiler.flow.FlowInfo;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.WithScope;

public class WithStatement
extends Statement {
    public Expression condition;
    public Statement action;

    public WithStatement(Expression condition, Statement action, int s, int e) {
        this.condition = condition;
        this.action = action;
        if (action instanceof EmptyStatement) {
            action.bits |= 1;
        }
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.condition.analyseCode(currentScope, flowContext, flowInfo);
        if (this.action != null && !this.action.complainIfUnreachable(flowInfo, currentScope, false)) {
            flowInfo = this.action.analyseCode(currentScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope currentScope, CodeStream codeStream) {
    }

    public void resolve(BlockScope parentScope) {
        BlockScope scope;
        TypeBinding type = this.condition.resolveTypeExpecting(parentScope, TypeBinding.ANY);
        BlockScope blockScope = scope = type instanceof ReferenceBinding ? new WithScope((Scope)parentScope, (ReferenceBinding)type) : parentScope;
        if (this.action != null) {
            this.action.resolve(scope);
        }
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        WithStatement.printIndent(tab, output).append("with (");
        this.condition.printExpression(0, output).append(")\n");
        if (this.action == null) {
            output.append(';');
        } else {
            this.action.printStatement(tab + 1, output);
        }
        return output;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.condition.traverse(visitor, blockScope);
            if (this.action != null) {
                this.action.traverse(visitor, blockScope);
            }
        }
        visitor.endVisit(this, blockScope);
    }
}

