/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.lookup;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.impl.Constant;
import org.eclipse.wst.jsdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.wst.jsdt.internal.infer.InferredAttribute;

public class FieldBinding
extends VariableBinding {
    public ReferenceBinding declaringClass;

    protected FieldBinding() {
        super(null, null, 0, null);
    }

    public FieldBinding(char[] name, TypeBinding type, int modifiers, ReferenceBinding declaringClass, Constant constant) {
        super(name, type, modifiers, constant);
        this.declaringClass = declaringClass;
    }

    public FieldBinding(InferredAttribute field, TypeBinding type, int modifiers, ReferenceBinding declaringClass) {
        this(field.name, type, modifiers, declaringClass, null);
        field.binding = this;
    }

    public FieldBinding(FieldBinding initialFieldBinding, ReferenceBinding declaringClass) {
        super(initialFieldBinding.name, initialFieldBinding.type, initialFieldBinding.modifiers, initialFieldBinding.constant());
        this.declaringClass = declaringClass;
        this.id = initialFieldBinding.id;
        this.setAnnotations(initialFieldBinding.getAnnotations());
    }

    public final int kind() {
        return 1;
    }

    public final boolean canBeSeenBy(PackageBinding invocationPackage) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return invocationPackage == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding receiverType, InvocationSite invocationSite, Scope scope) {
        if (!this.isPublic()) {
            // empty if block
        }
        return true;
    }

    public char[] computeUniqueKey(boolean isLeaf) {
        char[] cArray;
        char[] declaringKey = this.declaringClass == null ? CharOperation.NO_CHAR : this.declaringClass.computeUniqueKey(false);
        int declaringLength = declaringKey.length;
        int nameLength = this.name.length;
        if (this.type == null) {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = 86;
        } else {
            cArray = this.type.computeUniqueKey(false);
        }
        char[] returnTypeKey = cArray;
        int returnTypeLength = returnTypeKey.length;
        char[] uniqueKey = new char[declaringLength + 1 + nameLength + 1 + returnTypeLength];
        int index = 0;
        System.arraycopy(declaringKey, 0, uniqueKey, index, declaringLength);
        index += declaringLength;
        uniqueKey[index++] = 46;
        System.arraycopy(this.name, 0, uniqueKey, index, nameLength);
        index += nameLength;
        uniqueKey[index++] = 41;
        System.arraycopy(returnTypeKey, 0, uniqueKey, index, returnTypeLength);
        return uniqueKey;
    }

    public Constant constant() {
        Constant fieldConstant = this.constant;
        if (fieldConstant == null) {
            if (this.isFinal()) {
                FieldBinding originalField = this.original();
                if (originalField.declaringClass instanceof SourceTypeBinding) {
                    SourceTypeBinding sourceType = (SourceTypeBinding)originalField.declaringClass;
                    if (sourceType.scope != null) {
                        TypeDeclaration typeDecl = sourceType.classScope.referenceContext;
                        FieldDeclaration fieldDecl = typeDecl.declarationOf(originalField);
                        fieldDecl.resolve(originalField.isStatic() ? typeDecl.staticInitializerScope : typeDecl.initializerScope);
                        fieldConstant = originalField.constant();
                    } else {
                        fieldConstant = Constant.NotAConstant;
                    }
                } else {
                    fieldConstant = Constant.NotAConstant;
                }
            } else {
                fieldConstant = Constant.NotAConstant;
            }
            this.constant = fieldConstant;
        }
        return fieldConstant;
    }

    public char[] genericSignature() {
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        return this.type.genericTypeSignature();
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getAnnotationTagBits() {
        FieldBinding originalField = this.original();
        if ((originalField.tagBits & 0x200000000L) != 0L) return originalField.tagBits;
        if (!(originalField.declaringClass instanceof SourceTypeBinding)) return originalField.tagBits;
        ClassScope scope = ((SourceTypeBinding)originalField.declaringClass).classScope;
        if (scope == null) {
            this.tagBits |= 0x600000000L;
            return 0L;
        }
        TypeDeclaration typeDecl = scope.referenceContext;
        FieldDeclaration fieldDecl = typeDecl.declarationOf(originalField);
        if (fieldDecl == null) return originalField.tagBits;
        MethodScope initializationScope = this.isStatic() ? typeDecl.staticInitializerScope : typeDecl.initializerScope;
        FieldBinding previousField = initializationScope.initializedField;
        int previousFieldID = initializationScope.lastVisibleFieldID;
        try {
            initializationScope.initializedField = originalField;
            initializationScope.lastVisibleFieldID = originalField.id;
            ASTNode.resolveAnnotations(initializationScope, fieldDecl.annotations, originalField);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            initializationScope.initializedField = previousField;
            initializationScope.lastVisibleFieldID = previousFieldID;
            throw throwable;
        }
        {
            Object var8_10 = null;
            initializationScope.initializedField = previousField;
            initializationScope.lastVisibleFieldID = previousFieldID;
            return originalField.tagBits;
        }
    }

    public AnnotationBinding[] getAnnotations() {
        FieldBinding originalField = this.original();
        ReferenceBinding declaringClassBinding = originalField.declaringClass;
        if (declaringClassBinding == null) {
            return Binding.NO_ANNOTATIONS;
        }
        return declaringClassBinding.retrieveAnnotations(originalField);
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public FieldBinding original() {
        return this;
    }

    public void setAnnotations(AnnotationBinding[] annotations) {
        this.declaringClass.storeAnnotations(this, annotations);
    }

    public boolean isFor(AbstractVariableDeclaration variableDeclaration) {
        return false;
    }
}

