/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.compiler.problem;

import org.eclipse.wst.jsdt.core.compiler.CategorizedProblem;
import org.eclipse.wst.jsdt.internal.compiler.CompilationResult;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class AbortCompilation
extends RuntimeException {
    public CompilationResult compilationResult;
    public Throwable exception;
    public CategorizedProblem problem;
    public boolean isSilent;
    public RuntimeException silentException;
    private static final long serialVersionUID = -2047226595083244852L;

    public AbortCompilation() {
    }

    public AbortCompilation(CompilationResult compilationResult, CategorizedProblem problem) {
        this();
        this.compilationResult = compilationResult;
        this.problem = problem;
    }

    public AbortCompilation(CompilationResult compilationResult, Throwable exception) {
        this();
        this.compilationResult = compilationResult;
        this.exception = exception;
    }

    public AbortCompilation(boolean isSilent, RuntimeException silentException) {
        this();
        this.isSilent = isSilent;
        this.silentException = silentException;
    }

    public void updateContext(InvocationSite invocationSite, CompilationResult unitResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(invocationSite.sourceStart());
        this.problem.setSourceEnd(invocationSite.sourceEnd());
        int[] lineEnds = unitResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(invocationSite.sourceStart(), lineEnds, 0, lineEnds.length - 1));
        this.compilationResult = unitResult;
    }

    public void updateContext(ASTNode astNode, CompilationResult unitResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(astNode.sourceStart());
        this.problem.setSourceEnd(astNode.sourceEnd());
        int[] lineEnds = unitResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(astNode.sourceStart(), lineEnds, 0, lineEnds.length - 1));
    }

    public void updateContext(InferredType inferredType, CompilationResult unitResult) {
        if (this.problem == null) {
            return;
        }
        if (this.problem.getSourceStart() != 0 || this.problem.getSourceEnd() != 0) {
            return;
        }
        this.problem.setSourceStart(inferredType.sourceStart);
        this.problem.setSourceEnd(inferredType.sourceEnd);
        int[] lineEnds = unitResult.getLineSeparatorPositions();
        this.problem.setSourceLineNumber(Util.getLineNumber(inferredType.sourceStart, lineEnds, 0, lineEnds.length - 1));
        this.compilationResult = unitResult;
    }
}

