/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeParameter;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Binding;
import org.eclipse.wst.jsdt.internal.core.BinaryMember;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.JavadocConstants;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.wst.jsdt.internal.core.SourceMapper;
import org.eclipse.wst.jsdt.internal.core.TypeParameter;
import org.eclipse.wst.jsdt.internal.core.util.LRUCache;
import org.eclipse.wst.jsdt.internal.core.util.Util;

class BinaryMethod
extends BinaryMember
implements IMethod {
    protected String[] parameterTypes;
    protected String[] parameterNames;
    protected String[] exceptionTypes;
    protected String returnType;

    protected BinaryMethod(JavaElement parent, String name, String[] paramTypes) {
        super(parent, name);
        this.parameterTypes = paramTypes == null ? CharOperation.NO_STRINGS : paramTypes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BinaryMethod)) {
            return false;
        }
        return super.equals(o) && Util.equalArraysOrNull(this.parameterTypes, ((BinaryMethod)o).parameterTypes);
    }

    public String[] getExceptionTypes() throws JavaModelException {
        if (this.exceptionTypes == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            char[] genericSignature = info.getGenericSignature();
            if (genericSignature != null) {
                char[] dotBasedSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.');
                this.exceptionTypes = Signature.getThrownExceptionTypes(new String(dotBasedSignature));
            }
            if (this.exceptionTypes == null || this.exceptionTypes.length == 0) {
                char[][] eTypeNames = info.getExceptionTypeNames();
                if (eTypeNames == null || eTypeNames.length == 0) {
                    this.exceptionTypes = CharOperation.NO_STRINGS;
                } else {
                    eTypeNames = ClassFile.translatedNames(eTypeNames);
                    this.exceptionTypes = new String[eTypeNames.length];
                    int j = 0;
                    int length = eTypeNames.length;
                    while (j < length) {
                        int nameLength = eTypeNames[j].length;
                        char[] convertedName = new char[nameLength + 2];
                        System.arraycopy(eTypeNames[j], 0, convertedName, 1, nameLength);
                        convertedName[0] = 76;
                        convertedName[nameLength + 1] = 59;
                        this.exceptionTypes[j] = new String(convertedName);
                        ++j;
                    }
                }
            }
        }
        return this.exceptionTypes;
    }

    public int getElementType() {
        return 9;
    }

    public int getFlags() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.getModifiers();
    }

    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        char delimiter = this.getHandleMementoDelimiter();
        buff.append(delimiter);
        this.escapeMementoName(buff, this.getElementName());
        int i = 0;
        while (i < this.parameterTypes.length) {
            buff.append(delimiter);
            this.escapeMementoName(buff, this.parameterTypes[i]);
            ++i;
        }
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public String getKey(boolean forceOpen) throws JavaModelException {
        return this.getKey(this, forceOpen);
    }

    public int getNumberOfParameters() {
        return this.parameterTypes == null ? 0 : this.parameterTypes.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterNames() throws JavaModelException {
        IBinaryMethod info;
        int paramCount;
        if (this.parameterNames != null) {
            return this.parameterNames;
        }
        IType type = (IType)this.getParent();
        SourceMapper mapper = this.getSourceMapper();
        if (mapper != null) {
            char[][] paramNames = mapper.getMethodParameterNames(this);
            if (paramNames == null) {
                IBinaryType info2 = (IBinaryType)((BinaryType)this.getDeclaringType()).getElementInfo();
                char[] source = mapper.findSource(type, info2);
                if (source != null) {
                    mapper.mapSource(type, source, info2);
                }
                paramNames = mapper.getMethodParameterNames(this);
            }
            if (paramNames != null) {
                this.parameterNames = new String[paramNames.length];
                int i = 0;
                while (i < paramNames.length) {
                    this.parameterNames[i] = new String(paramNames[i]);
                    ++i;
                }
                return this.parameterNames;
            }
        }
        if ((paramCount = Signature.getParameterCount(new String((info = (IBinaryMethod)this.getElementInfo()).getMethodDescriptor()))) != 0) {
            int indexOfClosingParen;
            int indexOfOpenParen;
            int modifiers = this.getFlags();
            if ((modifiers & 0x1000) != 0) {
                this.parameterNames = this.getRawParameterNames(paramCount);
                return this.parameterNames;
            }
            String javadocContents = null;
            IType declaringType = this.getDeclaringType();
            JavaModelManager.PerProjectInfo projectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.getJavaProject().getProject());
            LRUCache lRUCache = projectInfo.javadocCache;
            synchronized (lRUCache) {
                javadocContents = (String)projectInfo.javadocCache.get(declaringType);
                if (javadocContents == null) {
                    projectInfo.javadocCache.put(declaringType, BinaryType.EMPTY_JAVADOC);
                }
            }
            if (javadocContents == null) {
                long timeOut = 50L;
                try {
                    String option = this.getJavaProject().getOption("org.eclipse.wst.jsdt.core.timeoutForParameterNameFromAttachedJavadoc", true);
                    if (option != null) {
                        timeOut = Long.parseLong(option);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (timeOut == 0L) {
                    this.parameterNames = this.getRawParameterNames(paramCount);
                    return this.parameterNames;
                }
                final class ParametersNameCollector {
                    String javadoc;

                    ParametersNameCollector() {
                    }

                    public void setJavadoc(String s) {
                        this.javadoc = s;
                    }

                    public String getJavadoc() {
                        return this.javadoc;
                    }
                }
                final ParametersNameCollector nameCollector = new ParametersNameCollector();
                Thread collect = new Thread(){
                    {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            nameCollector.setJavadoc(BinaryMethod.this.getAttachedJavadoc(null));
                        }
                        catch (JavaModelException javaModelException) {}
                        ParametersNameCollector parametersNameCollector = nameCollector;
                        synchronized (parametersNameCollector) {
                            nameCollector.notify();
                        }
                    }
                };
                collect.start();
                ParametersNameCollector parametersNameCollector = nameCollector;
                synchronized (parametersNameCollector) {
                    try {
                        nameCollector.wait(timeOut);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                javadocContents = nameCollector.getJavadoc();
            } else if (javadocContents != BinaryType.EMPTY_JAVADOC) {
                try {
                    javadocContents = this.extractJavadoc(declaringType, javadocContents);
                }
                catch (JavaModelException javaModelException) {}
            } else {
                char[][] argumentNames = info.getArgumentNames();
                if (argumentNames != null && argumentNames.length == paramCount) {
                    String[] names = new String[paramCount];
                    int i = 0;
                    while (i < paramCount) {
                        names[i] = new String(argumentNames[i]);
                        ++i;
                    }
                    this.parameterNames = names;
                    return names;
                }
                return this.getRawParameterNames(paramCount);
            }
            if (javadocContents != null && javadocContents != BinaryType.EMPTY_JAVADOC && (indexOfOpenParen = javadocContents.indexOf(40)) != -1 && (indexOfClosingParen = javadocContents.indexOf(41, indexOfOpenParen)) != -1) {
                char[] paramsSource = CharOperation.replace(javadocContents.substring(indexOfOpenParen + 1, indexOfClosingParen).toCharArray(), "&nbsp;".toCharArray(), new char[]{' '});
                char[][] params = this.splitParameters(paramsSource, paramCount);
                int paramsLength = params.length;
                this.parameterNames = new String[paramsLength];
                int i = 0;
                while (i < paramsLength) {
                    char[] param = params[i];
                    int indexOfSpace = CharOperation.lastIndexOf(' ', param);
                    this.parameterNames[i] = indexOfSpace != -1 ? String.valueOf(param, indexOfSpace + 1, param.length - indexOfSpace - 1) : "arg" + i;
                    ++i;
                }
                return this.parameterNames;
            }
            char[][] argumentNames = info.getArgumentNames();
            if (argumentNames != null && argumentNames.length == paramCount) {
                String[] names = new String[paramCount];
                int i = 0;
                while (i < paramCount) {
                    names[i] = new String(argumentNames[i]);
                    ++i;
                }
                this.parameterNames = names;
                return names;
            }
        }
        this.parameterNames = this.getRawParameterNames(paramCount);
        return this.parameterNames;
    }

    private char[][] splitParameters(char[] parametersSource, int paramCount) {
        char[][] params = new char[paramCount][];
        int paramIndex = 0;
        int index = 0;
        int balance = 0;
        int length = parametersSource.length;
        int start = 0;
        block6: while (index < length) {
            switch (parametersSource[index]) {
                case '<': {
                    ++balance;
                    ++index;
                    while (index < length && parametersSource[index] != '>') {
                        ++index;
                    }
                    continue block6;
                }
                case '>': {
                    --balance;
                    ++index;
                    break;
                }
                case ',': {
                    if (balance == 0 && paramIndex < paramCount) {
                        params[paramIndex++] = CharOperation.subarray(parametersSource, start, index);
                        start = index + 1;
                    }
                    ++index;
                    break;
                }
                case '&': {
                    if (index + 4 < length) {
                        if (parametersSource[index + 1] == 'l' && parametersSource[index + 2] == 't' && parametersSource[index + 3] == ';') {
                            ++balance;
                            index += 4;
                            break;
                        }
                        if (parametersSource[index + 1] == 'g' && parametersSource[index + 2] == 't' && parametersSource[index + 3] == ';') {
                            --balance;
                            index += 4;
                            break;
                        }
                        ++index;
                        break;
                    }
                    ++index;
                    break;
                }
                default: {
                    ++index;
                }
            }
        }
        if (paramIndex < paramCount) {
            params[paramIndex++] = CharOperation.subarray(parametersSource, start, index);
        }
        if (paramIndex != paramCount) {
            char[][] cArrayArray = params;
            params = new char[paramIndex][];
            System.arraycopy(cArrayArray, 0, params, 0, paramIndex);
        }
        return params;
    }

    public String[] getParameterTypes() {
        return this.parameterTypes;
    }

    public ITypeParameter getTypeParameter(String typeParameterName) {
        return new TypeParameter(this, typeParameterName);
    }

    public ITypeParameter[] getTypeParameters() throws JavaModelException {
        String[] typeParameterSignatures = this.getTypeParameterSignatures();
        int length = typeParameterSignatures.length;
        if (length == 0) {
            return TypeParameter.NO_TYPE_PARAMETERS;
        }
        ITypeParameter[] typeParameters = new ITypeParameter[length];
        int i = 0;
        while (i < typeParameterSignatures.length) {
            String typeParameterName = Signature.getTypeVariable(typeParameterSignatures[i]);
            typeParameters[i] = new TypeParameter(this, typeParameterName);
            ++i;
        }
        return typeParameters;
    }

    public String[] getTypeParameterSignatures() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        if (genericSignature == null) {
            return CharOperation.NO_STRINGS;
        }
        char[] dotBasedSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.');
        char[][] typeParams = Signature.getTypeParameters(dotBasedSignature);
        return CharOperation.toStrings(typeParams);
    }

    public String[] getRawParameterNames() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        int paramCount = Signature.getParameterCount(new String(info.getMethodDescriptor()));
        return this.getRawParameterNames(paramCount);
    }

    private String[] getRawParameterNames(int paramCount) {
        String[] result = new String[paramCount];
        int i = 0;
        while (i < paramCount) {
            result[i] = "arg" + i;
            ++i;
        }
        return result;
    }

    public String getReturnType() throws JavaModelException {
        if (this.returnType == null) {
            IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
            this.returnType = this.getReturnType(info);
        }
        return this.returnType;
    }

    private String getReturnType(IBinaryMethod info) {
        char[] genericSignature = info.getGenericSignature();
        char[] signature = genericSignature == null ? info.getMethodDescriptor() : genericSignature;
        char[] dotBasedSignature = CharOperation.replaceOnCopy(signature, '/', '.');
        String returnTypeName = Signature.getReturnType(new String(dotBasedSignature));
        return new String(ClassFile.translatedName(returnTypeName.toCharArray()));
    }

    public String getSignature() throws JavaModelException {
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return new String(info.getMethodDescriptor());
    }

    public int hashCode() {
        int hash = super.hashCode();
        return hash;
    }

    public boolean isConstructor() throws JavaModelException {
        if (!this.getElementName().equals(this.parent.getElementName())) {
            return false;
        }
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isResolved() {
        return false;
    }

    public boolean isSimilar(IMethod method) {
        return BinaryMethod.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append("(");
        String[] paramTypes = this.parameterTypes;
        if (paramTypes != null && (length = paramTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(paramTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(")");
        return buffer.toString();
    }

    public JavaElement resolved(Binding binding) {
        ResolvedBinaryMethod resolvedHandle = new ResolvedBinaryMethod(this.parent, this.name, this.parameterTypes, new String(binding.computeUniqueKey()));
        resolvedHandle.occurrenceCount = this.occurrenceCount;
        return resolvedHandle;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            this.toStringName(buffer);
            buffer.append(" (not open)");
        } else if (info == NO_INFO) {
            this.toStringName(buffer);
        } else {
            IBinaryMethod methodInfo = (IBinaryMethod)info;
            int flags = methodInfo.getModifiers();
            if (Flags.isStatic(flags)) {
                buffer.append("static ");
            }
            if (!methodInfo.isConstructor()) {
                buffer.append(Signature.toString(this.getReturnType(methodInfo)));
                buffer.append(' ');
            }
            this.toStringName(buffer, flags);
        }
    }

    protected void toStringName(StringBuffer buffer) {
        this.toStringName(buffer, 0);
    }

    protected void toStringName(StringBuffer buffer, int flags) {
        int length;
        buffer.append(this.getElementName());
        buffer.append('(');
        String[] parameters = this.getParameterTypes();
        if (parameters != null && (length = parameters.length) > 0) {
            boolean isVarargs = Flags.isVarargs(flags);
            int i = 0;
            while (i < length) {
                try {
                    if (i < length - 1) {
                        buffer.append(Signature.toString(parameters[i]));
                        buffer.append(", ");
                    } else if (isVarargs) {
                        String parameter = parameters[i].substring(1);
                        buffer.append(Signature.toString(parameter));
                        buffer.append(" ...");
                    } else {
                        buffer.append(Signature.toString(parameters[i]));
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    buffer.append("*** invalid signature: ");
                    buffer.append(parameters[i]);
                }
                ++i;
            }
        }
        buffer.append(')');
        if (this.occurrenceCount > 1) {
            buffer.append("#");
            buffer.append(this.occurrenceCount);
        }
    }

    public String getAttachedJavadoc(IProgressMonitor monitor) throws JavaModelException {
        IType declaringType = this.getDeclaringType();
        String contents = ((BinaryType)declaringType).getJavadocContents(monitor);
        return this.extractJavadoc(declaringType, contents);
    }

    private String extractJavadoc(IType declaringType, String contents) throws JavaModelException {
        int indexAnchor;
        if (contents == null) {
            return null;
        }
        String typeQualifiedName = null;
        boolean declaringTypeIsMember = declaringType.isMember();
        if (declaringTypeIsMember) {
            IType currentType = declaringType;
            StringBuffer buffer = new StringBuffer();
            while (currentType != null) {
                buffer.insert(0, currentType.getElementName());
                currentType = currentType.getDeclaringType();
                if (currentType == null) continue;
                buffer.insert(0, '.');
            }
            typeQualifiedName = new String(buffer.toString());
        } else {
            typeQualifiedName = declaringType.getElementName();
        }
        String methodName = this.getElementName();
        if (this.isConstructor()) {
            methodName = typeQualifiedName;
        }
        IBinaryMethod info = (IBinaryMethod)this.getElementInfo();
        char[] genericSignature = info.getGenericSignature();
        String anchor = null;
        if (genericSignature != null) {
            anchor = Util.toAnchor(genericSignature = CharOperation.replaceOnCopy(genericSignature, '/', '.'), methodName, Flags.isVarargs(this.getFlags()));
            if (anchor == null) {
                throw new JavaModelException(new JavaModelStatus(1009, this));
            }
        } else {
            anchor = Signature.toString(this.getSignature().replace('/', '.'), methodName, null, true, false, Flags.isVarargs(this.getFlags()));
        }
        if (declaringTypeIsMember) {
            int depth = 0;
            String packageFragmentName = declaringType.getPackageFragment().getElementName();
            IJavaProject javaProject = declaringType.getJavaProject();
            char[][] typeNames = CharOperation.splitOn('.', typeQualifiedName.toCharArray());
            if (!Flags.isStatic(declaringType.getFlags())) {
                ++depth;
            }
            StringBuffer typeName = new StringBuffer();
            int i = 0;
            int max = typeNames.length;
            while (i < max) {
                if (typeName.length() == 0) {
                    typeName.append(typeNames[i]);
                } else {
                    typeName.append('.').append(typeNames[i]);
                }
                IType resolvedType = javaProject.findType(packageFragmentName, String.valueOf(typeName));
                if (resolvedType != null && resolvedType.isMember() && !Flags.isStatic(resolvedType.getFlags())) {
                    ++depth;
                }
                ++i;
            }
            if (depth != 0) {
                int indexOfOpeningParen = anchor.indexOf(40);
                if (indexOfOpeningParen == -1) {
                    return null;
                }
                int index = indexOfOpeningParen++;
                int i2 = 0;
                while (i2 < depth) {
                    int indexOfComma = anchor.indexOf(44, index);
                    if (indexOfComma != -1) {
                        index = indexOfComma + 2;
                    }
                    ++i2;
                }
                anchor = String.valueOf(anchor.substring(0, indexOfOpeningParen)) + anchor.substring(index);
            }
        }
        if ((indexAnchor = contents.indexOf("<A NAME=\"" + anchor + "\"")) == -1) {
            return null;
        }
        int indexOfEndLink = contents.indexOf("</A>", indexAnchor);
        if (indexOfEndLink == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        int indexOfNextMethod = contents.indexOf("<A NAME=\"", indexOfEndLink);
        int indexOfBottom = -1;
        if (this.isConstructor()) {
            indexOfBottom = contents.indexOf("<!-- ============ METHOD DETAIL ========== -->", indexOfEndLink);
            if (indexOfBottom == -1) {
                indexOfBottom = contents.indexOf("<!-- ========= END OF CLASS DATA ========= -->", indexOfEndLink);
            }
        } else {
            indexOfBottom = contents.indexOf("<!-- ========= END OF CLASS DATA ========= -->", indexOfEndLink);
        }
        if (indexOfBottom == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        if ((indexOfNextMethod = Math.min(indexOfNextMethod, indexOfBottom)) == -1) {
            throw new JavaModelException(new JavaModelStatus(1009, this));
        }
        return contents.substring(indexOfEndLink + JavadocConstants.ANCHOR_SUFFIX_LENGTH, indexOfNextMethod);
    }

    public IMethod getMethod(String selector, String[] parameterTypeSignatures) {
        return null;
    }
}

