/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateTypeMemberOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class CreateMethodOperation
extends CreateTypeMemberOperation {
    protected String[] parameterTypes;

    public CreateMethodOperation(IJavaElement parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected String[] convertASTMethodTypesToSignatures() {
        if (this.parameterTypes == null && this.createdNode != null) {
            MethodDeclaration methodDeclaration = (MethodDeclaration)this.createdNode;
            List parameters = methodDeclaration.parameters();
            int size = parameters.size();
            this.parameterTypes = new String[size];
            Iterator iterator = parameters.iterator();
            int i = 0;
            while (i < size) {
                SingleVariableDeclaration parameter = (SingleVariableDeclaration)iterator.next();
                String typeSig = Util.getSignature(parameter.getType());
                int extraDimensions = parameter.getExtraDimensions();
                if (methodDeclaration.isVarargs() && i == size - 1) {
                    ++extraDimensions;
                }
                this.parameterTypes[i] = Signature.createArraySignature(typeSig, extraDimensions);
                ++i;
            }
        }
        return this.parameterTypes;
    }

    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, ICompilationUnit cu) throws JavaModelException {
        ASTNode node = super.generateElementAST(rewriter, document, cu);
        if (node.getNodeType() != 31) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return node;
    }

    protected IJavaElement generateResultHandle() {
        String[] types = this.convertASTMethodTypesToSignatures();
        String name = this.getASTNodeName();
        if (this.getType() != null) {
            return this.getType().getMethod(name, types);
        }
        return this.getCompilationUnit().getMethod(name, types);
    }

    private String getASTNodeName() {
        return ((MethodDeclaration)this.createdNode).getName().getIdentifier();
    }

    public String getMainTaskName() {
        return Messages.operation_createMethodProgress;
    }

    protected SimpleName rename(ASTNode node, SimpleName newName) {
        MethodDeclaration method = (MethodDeclaration)node;
        SimpleName oldName = method.getName();
        method.setName(newName);
        return oldName;
    }

    protected IJavaModelStatus verifyNameCollision() {
        if (this.createdNode != null) {
            IType type = this.getType();
            String name = ((MethodDeclaration)this.createdNode).isConstructor() ? type.getElementName() : this.getASTNodeName();
            String[] types = this.convertASTMethodTypesToSignatures();
            if (type != null ? type.getMethod(name, types).exists() : this.getCompilationUnit().getMethod(name, types).exists()) {
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, name));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

