/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IImportDeclaration;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaConventions;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateElementInCUOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CreatePackageDeclarationOperation
extends CreateElementInCUOperation {
    protected String name = null;

    public CreatePackageDeclarationOperation(String name, ICompilationUnit parentElement) {
        super(parentElement);
        this.name = name;
    }

    protected StructuralPropertyDescriptor getChildPropertyDescriptor(ASTNode parent) {
        return CompilationUnit.PACKAGE_PROPERTY;
    }

    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, ICompilationUnit cu) throws JavaModelException {
        IJavaElement[] children = this.getCompilationUnit().getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].getElementType() == 11 && this.name.equals(children[i].getElementName())) {
                this.creationOccurred = false;
                return null;
            }
            ++i;
        }
        AST ast = this.cuAST.getAST();
        PackageDeclaration pkgDeclaration = ast.newPackageDeclaration();
        Name astName = ast.newName(this.name);
        pkgDeclaration.setName(astName);
        return pkgDeclaration;
    }

    protected IJavaElement generateResultHandle() {
        return this.getCompilationUnit().getPackageDeclaration(this.name);
    }

    public String getMainTaskName() {
        return Messages.operation_createPackageProgress;
    }

    protected void initializeDefaultPosition() {
        try {
            ICompilationUnit cu = this.getCompilationUnit();
            IImportDeclaration[] imports = cu.getImports();
            if (imports.length > 0) {
                this.createBefore(imports[0]);
                return;
            }
            IType[] types = cu.getTypes();
            if (types.length > 0) {
                this.createBefore(types[0]);
                return;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    public IJavaModelStatus verify() {
        IJavaModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        IJavaProject project = this.getParentElement().getJavaProject();
        if (JavaConventions.validatePackageName(this.name, project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true), project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true)).getSeverity() == 4) {
            return new JavaModelStatus(983, this.name);
        }
        return JavaModelStatus.VERIFIED_OK;
    }
}

