/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaModelStatus;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.core.CreateTypeMemberOperation;
import org.eclipse.wst.jsdt.internal.core.JavaModelStatus;
import org.eclipse.wst.jsdt.internal.core.util.Messages;

public class CreateTypeOperation
extends CreateTypeMemberOperation {
    public CreateTypeOperation(IJavaElement parentElement, String source, boolean force) {
        super(parentElement, source, force);
    }

    protected ASTNode generateElementAST(ASTRewrite rewriter, IDocument document, ICompilationUnit cu) throws JavaModelException {
        ASTNode node = super.generateElementAST(rewriter, document, cu);
        if (!(node instanceof AbstractTypeDeclaration)) {
            throw new JavaModelException(new JavaModelStatus(984));
        }
        return node;
    }

    protected IJavaElement generateResultHandle() {
        IJavaElement parent = this.getParentElement();
        switch (parent.getElementType()) {
            case 5: {
                return ((ICompilationUnit)parent).getType(this.getASTNodeName());
            }
            case 7: {
                return ((IType)parent).getType(this.getASTNodeName());
            }
        }
        return null;
    }

    public String getMainTaskName() {
        return Messages.operation_createTypeProgress;
    }

    protected IType getType() {
        IJavaElement parent = this.getParentElement();
        if (parent.getElementType() == 7) {
            return (IType)parent;
        }
        return null;
    }

    protected IJavaModelStatus verifyNameCollision() {
        IJavaElement parent = this.getParentElement();
        switch (parent.getElementType()) {
            case 5: {
                String typeName = this.getASTNodeName();
                if (!((ICompilationUnit)parent).getType(typeName).exists()) break;
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, typeName));
            }
            case 7: {
                String typeName = this.getASTNodeName();
                if (!((IType)parent).getType(typeName).exists()) break;
                return new JavaModelStatus(977, Messages.bind(Messages.status_nameCollision, typeName));
            }
        }
        return JavaModelStatus.VERIFIED_OK;
    }

    private String getASTNodeName() {
        return ((AbstractTypeDeclaration)this.createdNode).getName().getIdentifier();
    }

    protected SimpleName rename(ASTNode node, SimpleName newName) {
        AbstractTypeDeclaration type = (AbstractTypeDeclaration)node;
        SimpleName oldName = type.getName();
        type.setName(newName);
        return oldName;
    }
}

