/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.CompilationUnit;
import org.eclipse.wst.jsdt.internal.core.CreateCompilationUnitOperation;
import org.eclipse.wst.jsdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;

public class DocumentContextFragment
extends PackageFragment {
    private String fileInScope;

    protected DocumentContextFragment(PackageFragmentRoot root, String names) {
        super(root, new String[]{names});
        this.names = new String[]{names};
        this.fileInScope = names;
    }

    protected boolean computeChildren(OpenableElementInfo info) {
        IJavaElement[] children = new IJavaElement[]{this.getJavaElement(this.fileInScope)};
        int k = 0;
        while (k < children.length) {
            info.addChild(children[k]);
            ++k;
        }
        return true;
    }

    public IJavaElement getJavaElement(String resource) {
        IResource elementResource = null;
        if (this.getResource() instanceof IContainer) {
            elementResource = ((IContainer)this.getResource()).findMember(resource);
        }
        if (elementResource != null && elementResource.exists()) {
            try {
                ICompilationUnit unit = this.getCompilationUnit(resource);
                return unit;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        return this.getClassFile(resource);
    }

    public IClassFile[] getClassFiles() throws JavaModelException {
        return new IClassFile[]{new ClassFile(this, this.fileInScope)};
    }

    public int getKind() throws JavaModelException {
        if (this.hasSource()) {
            return 1;
        }
        return super.getKind();
    }

    public boolean hasSource() {
        IResource file = ((IContainer)this.parent.getResource()).findMember(this.fileInScope);
        if (file != null && file.exists()) {
            return true;
        }
        return true;
    }

    public IResource getResource() {
        Path resourcePath = new Path(this.fileInScope);
        return ((IContainer)this.parent.getResource()).findMember(resourcePath.removeLastSegments(1));
    }

    public IClassFile getClassFile(String classFileName) {
        return new ClassFile(this, classFileName);
    }

    public ICompilationUnit getCompilationUnit(String cuName) {
        return new CompilationUnit(this, cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public ICompilationUnit createCompilationUnit(String cuName, String contents, boolean force, IProgressMonitor monitor) throws JavaModelException {
        CreateCompilationUnitOperation op = new CreateCompilationUnitOperation(this, cuName, contents, force);
        op.runOperation(monitor);
        return new CompilationUnit(this, cuName, DefaultWorkingCopyOwner.PRIMARY);
    }

    public String getElementName() {
        return "";
    }

    public boolean isDefaultPackage() {
        return true;
    }
}

