/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.core.IVirtualParent;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRootInfo;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragment;
import org.eclipse.wst.jsdt.internal.core.LibraryPackageFragmentInfo;
import org.eclipse.wst.jsdt.internal.core.OpenableElementInfo;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;

public class LibraryFragmentRoot
extends PackageFragmentRoot
implements IVirtualParent {
    protected final IPath libraryPath;
    protected boolean[] fLangeRuntime = new boolean[2];

    protected LibraryFragmentRoot(IPath jarPath, JavaProject project) {
        super(null, project);
        this.libraryPath = jarPath;
    }

    protected LibraryFragmentRoot(IResource resource, JavaProject project) {
        super(resource, project);
        this.libraryPath = resource.getFullPath();
    }

    public PackageFragment getPackageFragment(String[] pkgName) {
        return new LibraryPackageFragment(this, pkgName);
    }

    public IPath getPath() {
        if (this.isExternal()) {
            return this.libraryPath;
        }
        return super.getPath();
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (this.isExternal()) {
            if (!this.exists()) {
                throw this.newNotPresentException();
            }
            return null;
        }
        return super.getUnderlyingResource();
    }

    public IResource getResource() {
        if (this.resource == null) {
            this.resource = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.libraryPath, false);
        }
        if (this.resource instanceof IResource) {
            return super.getResource();
        }
        return null;
    }

    protected boolean computeChildren(OpenableElementInfo info, Map newElements) throws JavaModelException {
        String[] name = new String[]{""};
        LibraryPackageFragment packFrag = new LibraryPackageFragment(this, name);
        LibraryPackageFragmentInfo fragInfo = new LibraryPackageFragmentInfo();
        packFrag.computeChildren(fragInfo);
        newElements.put(packFrag, fragInfo);
        IJavaElement[] children = new IJavaElement[]{packFrag};
        info.setChildren(children);
        return true;
    }

    protected Object createElementInfo() {
        return new LibraryFragmentRootInfo();
    }

    protected int determineKind(IResource underlyingResource) {
        return 2;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof LibraryFragmentRoot) {
            LibraryFragmentRoot other = (LibraryFragmentRoot)o;
            return this.libraryPath.equals((Object)other.libraryPath);
        }
        return false;
    }

    public String getElementName() {
        return this.libraryPath.lastSegment();
    }

    public int hashCode() {
        return this.libraryPath.hashCode();
    }

    public boolean isExternal() {
        return this.getResource() == null;
    }

    public boolean isReadOnly() {
        return true;
    }

    protected boolean resourceExists() {
        if (this.isExternal()) {
            return JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), this.getPath(), true) != null;
        }
        return super.resourceExists();
    }

    protected void toStringAncestors(StringBuffer buffer) {
        if (this.isExternal()) {
            return;
        }
        super.toStringAncestors(buffer);
    }

    public boolean isResourceContainer() {
        return false;
    }

    public String getDisplayName() {
        ClasspathContainerInitializer containerInitializer = this.getContainerInitializer();
        if (containerInitializer != null) {
            return containerInitializer.getDescription(this.getPath(), this.getJavaProject());
        }
        return super.getDisplayName();
    }

    public ClasspathContainerInitializer getContainerInitializer() {
        IClasspathEntry fClassPathEntry = null;
        try {
            fClassPathEntry = this.getRawClasspathEntry();
        }
        catch (JavaModelException javaModelException) {}
        if (fClassPathEntry == null) {
            return null;
        }
        return JavaCore.getClasspathContainerInitializer(fClassPathEntry.getPath().segment(0));
    }

    public boolean isVirtual() {
        return true;
    }

    public boolean isLanguageRuntime() {
        if (this.fLangeRuntime[0]) {
            return this.fLangeRuntime[1];
        }
        ClasspathContainerInitializer init = this.getContainerInitializer();
        if (init == null) {
            this.fLangeRuntime[0] = true;
            this.fLangeRuntime[1] = false;
            return this.fLangeRuntime[1];
        }
        this.fLangeRuntime[1] = init.getKind() == 2 || init.getKind() == 3;
        this.fLangeRuntime[0] = true;
        return this.fLangeRuntime[1];
    }

    public boolean isLibrary() {
        return true;
    }
}

