/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.ClasspathContainerInitializer;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.libraries.LibraryLocation;
import org.eclipse.wst.jsdt.internal.core.UserLibrary;
import org.eclipse.wst.jsdt.internal.core.UserLibraryClasspathContainer;
import org.eclipse.wst.jsdt.internal.core.UserLibraryManager;

public class UserLibraryClasspathContainerInitializer
extends ClasspathContainerInitializer {
    public void initialize(IPath containerPath, IJavaProject project) throws CoreException {
        String userLibName;
        UserLibrary entries;
        if (this.isUserLibraryContainer(containerPath) && (entries = UserLibraryManager.getUserLibrary(userLibName = containerPath.segment(1))) != null) {
            UserLibraryClasspathContainer container = new UserLibraryClasspathContainer(userLibName);
            JavaCore.setClasspathContainer(containerPath, new IJavaProject[]{project}, new IClasspathContainer[]{container}, null);
        }
    }

    private boolean isUserLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.wst.jsdt.USER_LIBRARY".equals(path.segment(0));
    }

    public boolean canUpdateClasspathContainer(IPath containerPath, IJavaProject project) {
        return this.isUserLibraryContainer(containerPath);
    }

    public void requestClasspathContainerUpdate(IPath containerPath, IJavaProject project, IClasspathContainer containerSuggestion) throws CoreException {
        if (this.isUserLibraryContainer(containerPath)) {
            String name = containerPath.segment(1);
            if (containerSuggestion != null) {
                UserLibrary library = new UserLibrary(containerSuggestion.getClasspathEntries(), containerSuggestion.getKind() == 2);
                UserLibraryManager.setUserLibrary(name, library, null);
            } else {
                UserLibraryManager.setUserLibrary(name, null, null);
            }
        }
    }

    public String getDescription(IPath containerPath, IJavaProject project) {
        if (this.isUserLibraryContainer(containerPath)) {
            return containerPath.segment(1);
        }
        return super.getDescription(containerPath, project);
    }

    public Object getComparisonID(IPath containerPath, IJavaProject project) {
        return containerPath;
    }

    public LibraryLocation getLibraryLocation() {
        throw new UnimplementedException();
    }
}

