/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.util;

import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.EnumConstantDeclaration;
import org.eclipse.wst.jsdt.core.dom.EnumDeclaration;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeParameter;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;

public class DOMFinder
extends ASTVisitor {
    public ASTNode foundNode = null;
    public IBinding foundBinding = null;
    private CompilationUnit ast;
    private SourceRefElement element;
    private boolean resolveBinding;
    private int rangeStart = -1;
    private int rangeLength = 0;

    public DOMFinder(CompilationUnit ast, SourceRefElement element, boolean resolveBinding) {
        this.ast = ast;
        this.element = element;
        this.resolveBinding = resolveBinding;
    }

    protected boolean found(ASTNode node, ASTNode name) {
        if (name.getStartPosition() == this.rangeStart && name.getLength() == this.rangeLength) {
            this.foundNode = node;
            return true;
        }
        return false;
    }

    public ASTNode search() throws JavaModelException {
        ISourceRange range = null;
        range = this.element instanceof IMember && !(this.element instanceof IInitializer) ? ((IMember)((Object)this.element)).getNameRange() : this.element.getSourceRange();
        this.rangeStart = range.getOffset();
        this.rangeLength = range.getLength();
        this.ast.accept(this);
        return this.foundNode;
    }

    public boolean visit(AnnotationTypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(AnnotationTypeMemberDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(AnonymousClassDeclaration node) {
        ASTNode name;
        ASTNode parent = node.getParent();
        switch (parent.getNodeType()) {
            case 14: {
                name = ((ClassInstanceCreation)parent).getType();
                break;
            }
            case 72: {
                name = ((EnumConstantDeclaration)parent).getName();
                break;
            }
            default: {
                return true;
            }
        }
        if (this.found(node, name) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(EnumConstantDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveVariable();
        }
        return true;
    }

    public boolean visit(EnumDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(Initializer node) {
        this.found(node, node);
        return true;
    }

    public boolean visit(MethodDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(PackageDeclaration node) {
        if (this.found(node, node) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(TypeDeclaration node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(TypeParameter node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }

    public boolean visit(VariableDeclarationFragment node) {
        if (this.found(node, node.getName()) && this.resolveBinding) {
            this.foundBinding = node.resolveBinding();
        }
        return true;
    }
}

