/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.eval;

import org.eclipse.wst.jsdt.core.UnimplementedException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ClassFile;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.wst.jsdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.env.INameEnvironment;
import org.eclipse.wst.jsdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.wst.jsdt.internal.compiler.impl.ITypeRequestor;
import org.eclipse.wst.jsdt.internal.eval.EvaluationConstants;
import org.eclipse.wst.jsdt.internal.eval.EvaluationContext;
import org.eclipse.wst.jsdt.internal.eval.VariablesInfo;

public class CodeSnippetEnvironment
implements INameEnvironment,
EvaluationConstants {
    INameEnvironment env;
    EvaluationContext context;

    public CodeSnippetEnvironment(INameEnvironment env, EvaluationContext context) {
        this.env = env;
        this.context = context;
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName, ITypeRequestor requestor) {
        NameEnvironmentAnswer result = this.env.findType(compoundTypeName, requestor);
        if (result != null) {
            return result;
        }
        if (CharOperation.equals(compoundTypeName, ROOT_COMPOUND_NAME)) {
            IBinaryType binary = this.context.getRootCodeSnippetBinary();
            if (binary == null) {
                return null;
            }
            return new NameEnvironmentAnswer(binary, null);
        }
        VariablesInfo installedVars = this.context.installedVars;
        ClassFile[] classFiles = installedVars.classFiles;
        int i = 0;
        while (i < classFiles.length) {
            ClassFile classFile = classFiles[i];
            if (CharOperation.equals(compoundTypeName, classFile.getCompoundName())) {
                ClassFileReader binary = null;
                try {
                    binary = new ClassFileReader(classFile.getBytes(), null);
                }
                catch (ClassFormatException e) {
                    e.printStackTrace();
                    return null;
                }
                return new NameEnvironmentAnswer(binary, null);
            }
            ++i;
        }
        return null;
    }

    public NameEnvironmentAnswer findBinding(char[] typeName, char[][] packageName, int type, ITypeRequestor requestor, boolean returnMultiple, String excludePath) {
        throw new UnimplementedException();
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName, ITypeRequestor requestor) {
        NameEnvironmentAnswer result = this.env.findType(typeName, packageName, requestor);
        if (result != null) {
            return result;
        }
        return this.findType(CharOperation.arrayConcat(packageName, typeName), requestor);
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        return this.env.isPackage(parentPackageName, packageName);
    }

    public void cleanup() {
        this.env.cleanup();
    }
}

