/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ASTVisitor;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Argument;
import org.eclipse.wst.jsdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.wst.jsdt.internal.compiler.ast.Assignment;
import org.eclipse.wst.jsdt.internal.compiler.ast.CharLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.Expression;
import org.eclipse.wst.jsdt.internal.compiler.ast.FalseLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.FieldReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.FunctionExpression;
import org.eclipse.wst.jsdt.internal.compiler.ast.Javadoc;
import org.eclipse.wst.jsdt.internal.compiler.ast.JavadocSingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MessageSend;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ObjectLiteralField;
import org.eclipse.wst.jsdt.internal.compiler.ast.ProgramElement;
import org.eclipse.wst.jsdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.wst.jsdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.StringLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.ThisReference;
import org.eclipse.wst.jsdt.internal.compiler.ast.TrueLiteral;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeReference;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.Scope;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.compiler.util.Util;
import org.eclipse.wst.jsdt.internal.infer.InferOptions;
import org.eclipse.wst.jsdt.internal.infer.InferredAttribute;
import org.eclipse.wst.jsdt.internal.infer.InferredMember;
import org.eclipse.wst.jsdt.internal.infer.InferredMethod;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class InferEngine
extends ASTVisitor {
    InferOptions inferOptions;
    CompilationUnitDeclaration compUnit;
    Context[] contexts = new Context[100];
    int contextPtr = -1;
    Context currentContext = new Context();
    int passNumber = 1;
    boolean isTopLevelAnonymousFunction;
    int anonymousCount = 0;
    public InferredType StringType = new InferredType(new char[]{'S', 't', 'r', 'i', 'n', 'g'});
    public InferredType NumberType = new InferredType(new char[]{'N', 'u', 'm', 'b', 'e', 'r'});
    public InferredType BooleanType = new InferredType(new char[]{'B', 'o', 'o', 'l', 'e', 'a', 'n'});
    public InferredType ArrayType = new InferredType(InferredType.ARRAY_NAME);
    public InferredType VoidType = new InferredType(new char[]{'v', 'o', 'i', 'd'});
    public InferredType ObjectType = new InferredType(InferredType.OBJECT_NAME);
    public InferredType GlobalType = new InferredType(InferredType.GLOBAL_NAME);
    protected InferredType inferredGlobal = null;
    static final char[] CONSTRUCTOR_ID = new char[]{'c', 'o', 'n', 's', 't', 'r', 'u', 'c', 't', 'o', 'r'};
    public static final char[] ANONYMOUS_PREFIX = new char[]{'_', '_', '_'};
    public static final char[] ANONYMOUS_CLASS_ID = new char[]{'a', 'n', 'o', 'n', 'y', 'm', 'o', 'u', 's'};

    public InferEngine(InferOptions inferOptions) {
        this.inferOptions = inferOptions;
    }

    public InferEngine() {
        this.inferOptions = new InferOptions();
    }

    public void initialize() {
        this.contextPtr = -1;
        this.currentContext = new Context();
        this.passNumber = 1;
        this.isTopLevelAnonymousFunction = false;
        this.anonymousCount = 0;
        this.inferredGlobal = null;
    }

    public void setCompilationUnit(CompilationUnitDeclaration compilationUnit) {
        this.compUnit = compilationUnit;
        this.buildDefinedMembers(compilationUnit.statements, null);
    }

    public boolean visit(MessageSend messageSend, BlockScope scope) {
        boolean visitChildren = this.handleFunctionCall(messageSend);
        if (visitChildren && this.contextPtr == -1 && messageSend.receiver instanceof FunctionExpression) {
            this.isTopLevelAnonymousFunction = true;
        }
        return visitChildren;
    }

    public boolean visit(LocalDeclaration localDeclaration, BlockScope scope) {
        this.currentContext.addMember(localDeclaration.name, localDeclaration);
        if (localDeclaration.javadoc != null) {
            InferredType type;
            Javadoc javadoc = localDeclaration.javadoc;
            InferredAttribute attribute = null;
            if (javadoc.memberOf != null) {
                type = this.addType(javadoc.memberOf.getSimpleTypeName());
                attribute = type.addAttribute(localDeclaration.name, localDeclaration);
                if (localDeclaration.initialization != null) {
                    attribute.initializationStart = localDeclaration.initialization.sourceStart;
                }
                attribute.type = type;
            }
            if (javadoc.returnType != null) {
                localDeclaration.inferredType = type = this.addType(javadoc.returnType.getSimpleTypeName());
                if (attribute != null) {
                    attribute.type = type;
                }
            }
        }
        if (localDeclaration.inferredType == null && localDeclaration.initialization != null) {
            localDeclaration.inferredType = this.getTypeOf(localDeclaration.initialization);
        }
        return true;
    }

    public boolean visit(Assignment assignment, BlockScope scope) {
        this.pushContext();
        if (!this.handlePrototype(assignment)) {
            if (assignment.expression instanceof FunctionExpression) {
                FunctionExpression functionExpression = (FunctionExpression)assignment.expression;
                char[] possibleTypeName = this.constructTypeName(assignment.lhs);
                InferredType type = null;
                if (possibleTypeName != null) {
                    type = this.compUnit.findInferredType(possibleTypeName);
                }
                if (type != null) {
                    if (this.inferOptions.useInitMethod) {
                        this.currentContext.currentType = type;
                        this.currentContext.currentType = type;
                        type.isDefinition = true;
                        InferredMethod method = type.addMethod(type.name, functionExpression.methodDeclaration);
                        method.isConstructor = true;
                        method.nameStart = assignment.lhs.sourceStart;
                    }
                } else if (assignment.lhs instanceof FieldReference) {
                    FieldReference fieldReference = (FieldReference)assignment.lhs;
                    int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                    InferredType receiverType = this.getInferredType(fieldReference.receiver);
                    if (receiverType != null) {
                        InferredMethod method = receiverType.findMethod(fieldReference.token, functionExpression.methodDeclaration);
                        if (method == null) {
                            method = receiverType.addMethod(fieldReference.token, functionExpression.methodDeclaration);
                            receiverType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                            method.nameStart = nameStart;
                            char[] possibleInTypeName = this.constructTypeName(fieldReference.receiver);
                            method.isStatic = possibleInTypeName != null && this.compUnit.findInferredType(possibleInTypeName) != null;
                            return true;
                        }
                        return false;
                    }
                    if (this.passNumber == 2 && (receiverType = this.getInferredType2(fieldReference.receiver)) != null) {
                        InferredMethod method = receiverType.addMethod(fieldReference.token, functionExpression.methodDeclaration);
                        method.nameStart = nameStart;
                        receiverType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                    }
                }
            } else if (assignment.expression instanceof SingleNameReference && this.currentContext.currentType != null && InferEngine.isThis(assignment.lhs)) {
                SingleNameReference snr = (SingleNameReference)assignment.expression;
                Object object = this.currentContext.getMember(snr.token);
                FieldReference fieldReference = (FieldReference)assignment.lhs;
                char[] memberName = fieldReference.token;
                InferredMember member = null;
                if (object instanceof MethodDeclaration) {
                    MethodDeclaration method = (MethodDeclaration)object;
                    member = this.currentContext.currentType.addMethod(memberName, method);
                } else {
                    member = this.currentContext.currentType.addAttribute(memberName, assignment);
                    member.type = this.getTypeOf(assignment.expression);
                }
                if (member != null) {
                    member.isStatic = false;
                    member.nameStart = fieldReference.sourceEnd - memberName.length + 1;
                }
            } else if (assignment.expression instanceof ObjectLiteral && assignment.lhs instanceof SingleNameReference) {
                AbstractVariableDeclaration varDecl = this.getVariable(assignment.lhs);
                if (varDecl != null) {
                    InferredType type = varDecl.inferredType;
                    if (type == null) {
                        varDecl.inferredType = type = this.getTypeOf(assignment.expression);
                        return true;
                    }
                    return false;
                }
            } else if (assignment.expression instanceof ObjectLiteral && assignment.lhs instanceof FieldReference) {
                if (this.inferOptions.useAssignments && this.passNumber == 2) {
                    InferredAttribute attr;
                    FieldReference fRef = (FieldReference)assignment.lhs;
                    InferredType receiverType = this.getInferredType(fRef.receiver);
                    if (receiverType == null && this.passNumber == 2) {
                        receiverType = this.getInferredType2(fRef.receiver);
                    }
                    if (receiverType != null && ((attr = receiverType.findAttribute(fRef.token)) == null || attr.type == null)) {
                        attr = receiverType.addAttribute(fRef.token, assignment);
                        attr.type = this.getTypeOf(assignment.expression);
                        char[] possibleTypeName = this.constructTypeName(fRef.receiver);
                        attr.isStatic = possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                        attr.nameStart = (int)(fRef.nameSourcePosition >>> 32);
                        return false;
                    }
                }
            } else if (this.inferOptions.useAssignments && assignment.lhs instanceof FieldReference) {
                FieldReference fRef = (FieldReference)assignment.lhs;
                int nameStart = (int)(fRef.nameSourcePosition >>> 32);
                InferredType receiverType = this.getInferredType(fRef.receiver);
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(fRef.receiver);
                }
                if (receiverType != null) {
                    InferredMethod method = null;
                    InferredAttribute attr = receiverType.findAttribute(fRef.token);
                    if (attr == null) {
                        method = receiverType.findMethod(fRef.token, null);
                    }
                    if (method == null && attr == null || method == null && attr != null && attr.type == null) {
                        MethodDeclaration definedFunction = null;
                        InferredType exprType = this.getTypeOf(assignment.expression);
                        if (exprType == null) {
                            definedFunction = this.getDefinedFunction(assignment.expression);
                        }
                        if (definedFunction != null) {
                            method = receiverType.addMethod(fRef.token, definedFunction);
                            method.nameStart = nameStart;
                        } else {
                            attr = receiverType.addAttribute(fRef.token, assignment);
                            attr.type = exprType;
                            char[] possibleTypeName = this.constructTypeName(fRef.receiver);
                            attr.isStatic = possibleTypeName != null && this.compUnit.findInferredType(possibleTypeName) != null;
                            attr.nameStart = (int)(fRef.nameSourcePosition >>> 32);
                        }
                        return false;
                    }
                }
            }
        }
        return true;
    }

    protected InferredType getInferredType2(Expression fieldReceiver) {
        char[] name;
        InferredAttribute attr;
        InferredType receiverType = null;
        AbstractVariableDeclaration var = this.getVariable(fieldReceiver);
        if (var != null) {
            receiverType = this.createAnonymousType(var);
        } else if (this.inferredGlobal != null && fieldReceiver instanceof SingleNameReference && (attr = (InferredAttribute)this.inferredGlobal.attributesHash.get(name = ((SingleNameReference)fieldReceiver).token)) != null) {
            receiverType = attr.type;
        }
        return receiverType;
    }

    private InferredType createAnonymousType(AbstractVariableDeclaration var) {
        InferredType currentType = var.inferredType;
        if (currentType == null || !currentType.isAnonymous) {
            char[] cs = String.valueOf(this.anonymousCount++).toCharArray();
            char[] name = CharOperation.concat(ANONYMOUS_PREFIX, var.name, cs);
            InferredType type = this.addType(name);
            type.isDefinition = true;
            type.isAnonymous = true;
            if (currentType != null) {
                type.superClass = currentType;
            }
            var.inferredType = type;
        }
        return var.inferredType;
    }

    private InferredType createAnonymousType(ObjectLiteral objLit) {
        char[] loc = (String.valueOf(String.valueOf(objLit.sourceStart)) + '_' + String.valueOf(objLit.sourceEnd)).toCharArray();
        char[] name = CharOperation.concat(ANONYMOUS_PREFIX, ANONYMOUS_CLASS_ID, loc);
        InferredType anonType = this.addType(name);
        anonType.isDefinition = true;
        anonType.isAnonymous = true;
        anonType.superClass = this.ObjectType;
        anonType.sourceStart = objLit.sourceStart;
        anonType.sourceEnd = objLit.sourceEnd;
        this.populateType(anonType, objLit);
        return anonType;
    }

    protected boolean handlePrototype(Assignment assignment) {
        Expression lhs = assignment.lhs;
        if (lhs instanceof FieldReference) {
            FieldReference fieldReference = (FieldReference)lhs;
            if (fieldReference.isPrototype()) {
                InferredType newType = null;
                char[] possibleTypeName = this.constructTypeName(fieldReference.receiver);
                if (possibleTypeName == null) {
                    return true;
                }
                newType = this.compUnit.findInferredType(possibleTypeName);
                if (newType == null) {
                    newType = this.addType(possibleTypeName);
                    newType.isDefinition = true;
                }
                newType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                if (assignment.expression instanceof AllocationExpression) {
                    AllocationExpression allocationExpression = (AllocationExpression)assignment.expression;
                    InferredType superType = null;
                    char[] possibleSuperTypeName = this.constructTypeName(allocationExpression.member);
                    if (possibleSuperTypeName != null) {
                        superType = this.compUnit.findInferredType(possibleSuperTypeName);
                        if (superType == null) {
                            superType = this.addType(possibleSuperTypeName);
                        }
                        if (newType.superClass == null) {
                            newType.superClass = superType;
                        }
                    }
                    return true;
                }
                if (assignment.expression instanceof ObjectLiteral) {
                    this.populateType(newType, (ObjectLiteral)assignment.expression);
                    if (newType.superClass == null) {
                        newType.superClass = this.ObjectType;
                    }
                    return true;
                }
            } else if (fieldReference.receiver.isPrototype()) {
                FieldReference prototype = (FieldReference)fieldReference.receiver;
                InferredType newType = null;
                char[] possibleTypeName = this.constructTypeName(prototype.receiver);
                if (possibleTypeName == null) {
                    return true;
                }
                newType = this.compUnit.findInferredType(possibleTypeName);
                if (newType == null) {
                    newType = this.addType(possibleTypeName);
                    newType.isDefinition = true;
                }
                newType.updatePositions(assignment.sourceStart, assignment.sourceEnd);
                if (this.passNumber == 1 && assignment.expression instanceof ObjectLiteral) {
                    return false;
                }
                char[] memberName = fieldReference.token;
                int nameStart = (int)(fieldReference.nameSourcePosition >>> 32);
                InferredType typeOf = this.getTypeOf(assignment.expression);
                MethodDeclaration methodDecl = null;
                if (typeOf == null) {
                    methodDecl = this.getDefinedFunction(assignment.expression);
                }
                if (methodDecl != null) {
                    InferredMethod method = newType.addMethod(memberName, methodDecl);
                    method.nameStart = nameStart;
                } else if (!CharOperation.equals(CONSTRUCTOR_ID, memberName)) {
                    InferredAttribute attribute = newType.addAttribute(memberName, assignment);
                    attribute.initializationStart = assignment.expression.sourceStart;
                    attribute.nameStart = nameStart;
                    if (attribute.type == null) {
                        attribute.type = typeOf;
                    }
                }
                return true;
            }
        }
        return false;
    }

    protected MethodDeclaration getDefinedFunction(Expression expression) {
        if (expression instanceof SingleNameReference) {
            Object object = this.currentContext.getMember(((SingleNameReference)expression).token);
            if (object instanceof AbstractMethodDeclaration) {
                return (MethodDeclaration)object;
            }
        } else {
            if (expression instanceof FunctionExpression) {
                return ((FunctionExpression)expression).methodDeclaration;
            }
            if (expression instanceof FieldReference) {
                InferredMethod method;
                FieldReference fieldReference = (FieldReference)expression;
                InferredType receiverType = this.getInferredType(fieldReference.receiver);
                if (receiverType == null && this.passNumber == 2) {
                    receiverType = this.getInferredType2(fieldReference.receiver);
                }
                if (receiverType != null && (method = receiverType.findMethod(fieldReference.token, null)) != null) {
                    return method.methodDeclaration;
                }
            }
        }
        return null;
    }

    protected InferredType getTypeOf(Expression expression) {
        if (expression instanceof StringLiteral || expression instanceof CharLiteral) {
            return this.StringType;
        }
        if (expression instanceof NumberLiteral) {
            return this.NumberType;
        }
        if (expression instanceof AllocationExpression) {
            AllocationExpression allocationExpression = (AllocationExpression)expression;
            InferredType type = null;
            char[] possibleTypeName = this.constructTypeName(allocationExpression.member);
            if (possibleTypeName != null) {
                type = this.compUnit.findInferredType(possibleTypeName);
                if (type == null) {
                    type = this.addType(possibleTypeName);
                }
                return type;
            }
        } else if (expression instanceof SingleNameReference) {
            InferredAttribute attribute;
            AbstractVariableDeclaration varDecl = this.getVariable(expression);
            if (varDecl != null) {
                return varDecl.inferredType;
            }
            if (this.inferredGlobal != null && (attribute = this.inferredGlobal.findAttribute(((SingleNameReference)expression).token)) != null) {
                return attribute.type;
            }
        } else if (expression instanceof FieldReference) {
            InferredAttribute attribute;
            FieldReference fieldReference = (FieldReference)expression;
            if (fieldReference.receiver.isThis() && this.currentContext.currentType != null && (attribute = this.currentContext.currentType.findAttribute(fieldReference.token)) != null) {
                return attribute.type;
            }
        } else {
            if (expression instanceof ArrayInitializer) {
                ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                boolean typeSet = false;
                InferredType memberType = null;
                if (arrayInitializer.expressions != null) {
                    int i = 0;
                    while (i < arrayInitializer.expressions.length) {
                        InferredType thisType = this.getTypeOf(arrayInitializer.expressions[i]);
                        if (thisType != null) {
                            if (!thisType.equals(memberType)) {
                                memberType = !typeSet ? thisType : null;
                            }
                            typeSet = true;
                        }
                        ++i;
                    }
                }
                if (memberType != null) {
                    InferredType type = new InferredType(InferredType.ARRAY_NAME);
                    type.referenceClass = memberType;
                    return type;
                }
                return this.ArrayType;
            }
            if (expression instanceof TrueLiteral || expression instanceof FalseLiteral) {
                return this.BooleanType;
            }
            if (expression instanceof ObjectLiteral) {
                InferredType type = this.createAnonymousType((ObjectLiteral)expression);
                type.sourceStart = expression.sourceStart;
                type.sourceEnd = expression.sourceEnd;
                return type;
            }
        }
        return null;
    }

    private void populateType(InferredType type, ObjectLiteral objLit) {
        if (objLit.fields != null) {
            int i = 0;
            while (i < objLit.fields.length) {
                ObjectLiteralField field = objLit.fields[i];
                char[] name = null;
                int nameStart = -1;
                if (field.fieldName instanceof SingleNameReference) {
                    SingleNameReference singleNameReference = (SingleNameReference)field.fieldName;
                    name = singleNameReference.token;
                    nameStart = singleNameReference.sourceStart;
                    if (field.initializer instanceof FunctionExpression) {
                        FunctionExpression functionExpression = (FunctionExpression)field.initializer;
                        InferredMethod method = type.addMethod(name, functionExpression.methodDeclaration);
                        method.nameStart = nameStart;
                    } else {
                        InferredAttribute attribute = type.addAttribute(name, field.fieldName);
                        attribute.nameStart = nameStart;
                        attribute.type = this.getTypeOf(field.initializer);
                    }
                }
                ++i;
            }
        }
    }

    public void endVisit(Assignment assignment, BlockScope scope) {
        this.popContext();
    }

    protected boolean handleFunctionCall(MessageSend messageSend) {
        return true;
    }

    public void endVisit(ReturnStatement returnStatement, BlockScope scope) {
        if (this.currentContext.currentMethod != null && returnStatement.expression != null) {
            InferredType type = this.getTypeOf(returnStatement.expression);
            if (this.currentContext.currentMethod.inferredType == this.VoidType) {
                this.currentContext.currentMethod.inferredType = type;
            } else if (type == null || !type.equals(this.currentContext.currentMethod.inferredType)) {
                this.currentContext.currentMethod.inferredType = null;
            }
        }
    }

    public void endVisit(MethodDeclaration methodDeclaration, Scope scope) {
        this.popContext();
    }

    public boolean visit(MethodDeclaration methodDeclaration, Scope scope) {
        InferredType type;
        this.pushContext();
        if (this.isTopLevelAnonymousFunction && this.currentContext.currentType == null) {
            this.currentContext.currentType = this.addType(InferredType.GLOBAL_NAME);
            this.currentContext.currentType.isDefinition = true;
            this.inferredGlobal = this.currentContext.currentType;
        }
        this.isTopLevelAnonymousFunction = false;
        if (this.passNumber == 1) {
            this.buildDefinedMembers(methodDeclaration.statements, methodDeclaration.arguments);
            if (methodDeclaration.javadoc != null) {
                InferredType type2;
                InferredMethod method = null;
                Javadoc javadoc = methodDeclaration.javadoc;
                if (javadoc.isConstructor) {
                    type2 = this.addType(methodDeclaration.selector);
                    type2.isDefinition = true;
                    method = type2.addMethod(methodDeclaration.selector, methodDeclaration);
                    method.nameStart = methodDeclaration.sourceStart;
                    method.isConstructor = true;
                    if (javadoc.extendsType != null) {
                        InferredType superType;
                        type2.superClass = superType = this.addType(javadoc.extendsType.getSimpleTypeName());
                    }
                } else if (javadoc.memberOf != null) {
                    type2 = this.addType(javadoc.memberOf.getSimpleTypeName());
                    method = type2.addMethod(methodDeclaration.selector, methodDeclaration);
                }
                if (javadoc.returnType != null) {
                    methodDeclaration.inferredType = type2 = this.addType(javadoc.returnType.getSimpleTypeName());
                }
            }
            if (methodDeclaration.arguments != null) {
                this.handleFunctionDeclarationArguments(methodDeclaration);
            }
        }
        if (this.passNumber == 2 && methodDeclaration.selector != null && (type = this.compUnit.findInferredType(methodDeclaration.selector)) != null) {
            this.currentContext.currentType = type;
            type.isDefinition = true;
            InferredMethod method = type.addMethod(methodDeclaration.selector, methodDeclaration);
            method.nameStart = methodDeclaration.sourceStart;
            method.isConstructor = true;
            methodDeclaration.inferredType = type;
        }
        this.currentContext.currentMethod = methodDeclaration;
        if (methodDeclaration.inferredMethod != null && methodDeclaration.inferredMethod.inType != null) {
            this.currentContext.currentType = methodDeclaration.inferredMethod.inType;
        }
        if (methodDeclaration.inferredType == null) {
            methodDeclaration.inferredType = this.VoidType;
        }
        return true;
    }

    protected void handleFunctionDeclarationArguments(MethodDeclaration methodDeclaration) {
        Javadoc javadoc = methodDeclaration.javadoc;
        if (javadoc == null) {
            return;
        }
        int i = 0;
        while (i < methodDeclaration.arguments.length) {
            int j;
            JavadocSingleNameReference param = javadoc.findParam(methodDeclaration.arguments[i].name);
            if (param != null && param.types != null && (j = 0) < param.types.length) {
                InferredType paramType;
                TypeReference reference = param.types[j];
                methodDeclaration.arguments[i].inferredType = paramType = this.addType(reference.getSimpleTypeName());
            }
            ++i;
        }
    }

    public boolean visit(AllocationExpression allocationExpression, BlockScope scope) {
        InferredType type = null;
        char[] possibleTypeName = this.constructTypeName(allocationExpression.member);
        if (possibleTypeName != null && (type = this.compUnit.findInferredType(possibleTypeName)) == null) {
            type = this.addType(possibleTypeName);
        }
        return true;
    }

    public void endVisit(ObjectLiteralField field, BlockScope scope) {
        if (field.javaDoc != null) {
            Javadoc javaDoc = field.javaDoc;
            InferredType inClass = null;
            char[] name = null;
            int nameStart = -1;
            InferredType returnType = null;
            if (field.fieldName instanceof SingleNameReference) {
                SingleNameReference singleNameReference = (SingleNameReference)field.fieldName;
                name = singleNameReference.token;
                nameStart = singleNameReference.sourceStart;
            }
            if (javaDoc.memberOf != null) {
                inClass = this.addType(javaDoc.memberOf.getSimpleTypeName());
                inClass.isDefinition = true;
            }
            if (javaDoc.returnType != null) {
                returnType = this.addType(javaDoc.returnType.getSimpleTypeName());
            }
            if (inClass != null) {
                if (field.initializer instanceof FunctionExpression) {
                    FunctionExpression functionExpression = (FunctionExpression)field.initializer;
                    InferredMethod method = inClass.addMethod(name, functionExpression.methodDeclaration);
                    method.nameStart = nameStart;
                    functionExpression.methodDeclaration.modifiers = javaDoc.modifiers;
                    if (returnType != null) {
                        functionExpression.methodDeclaration.inferredType = returnType;
                    }
                } else {
                    InferredAttribute attribute = inClass.addAttribute(name, field.fieldName);
                    attribute.nameStart = field.fieldName.sourceStart;
                    if (returnType != null) {
                        attribute.type = returnType;
                    }
                }
            }
        } else {
            boolean cfr_ignored_0 = field.initializer instanceof ObjectLiteral;
        }
    }

    protected boolean isMatch(Expression expr, String[] names, int index) {
        char[] matchName = names[index].toCharArray();
        if (expr instanceof SingleNameReference) {
            SingleNameReference snr = (SingleNameReference)expr;
            return CharOperation.equals(snr.token, matchName);
        }
        if (expr instanceof FieldReference && names.length > 1) {
            FieldReference fieldReference = (FieldReference)expr;
            if (CharOperation.equals(fieldReference.token, matchName)) {
                return this.isMatch(fieldReference.receiver, names, index - 1);
            }
        }
        return false;
    }

    protected boolean isFunction(MessageSend messageSend, String string) {
        String[] names = string.split("\\.");
        char[] functionName = names[names.length - 1].toCharArray();
        if (!CharOperation.equals(functionName, messageSend.selector)) {
            return false;
        }
        if (names.length > 1) {
            return this.isMatch(messageSend.receiver, names, names.length - 2);
        }
        return true;
    }

    public void doInfer() {
        this.compUnit.traverse(this, this.compUnit.scope, true);
        this.passNumber = 2;
        this.compUnit.traverse(this, this.compUnit.scope, true);
        this.compUnit = null;
    }

    protected InferredType addType(char[] className) {
        InferredType type = this.compUnit.findInferredType(className);
        if (type == null) {
            if (this.compUnit.numberInferredTypes == this.compUnit.inferredTypes.length) {
                this.compUnit.inferredTypes = new InferredType[this.compUnit.numberInferredTypes * 2];
                System.arraycopy(this.compUnit.inferredTypes, 0, this.compUnit.inferredTypes, 0, this.compUnit.numberInferredTypes);
            }
            InferredType inferredType = new InferredType(className);
            this.compUnit.inferredTypes[this.compUnit.numberInferredTypes++] = inferredType;
            type = inferredType;
            this.compUnit.inferredTypesHash.put(className, type);
        }
        return type;
    }

    protected final void pushContext() {
        Context newContext = new Context(this.currentContext);
        this.contexts[++this.contextPtr] = this.currentContext;
        this.currentContext = newContext;
    }

    protected final void popContext() {
        this.currentContext = this.contexts[this.contextPtr];
        this.contexts[this.contextPtr--] = null;
    }

    protected final boolean isInNamedMethod() {
        return this.currentContext.currentMethod != null && this.currentContext.currentMethod.selector != null;
    }

    protected AbstractVariableDeclaration getVariable(Expression expression) {
        Object var;
        char[] name = null;
        if (expression instanceof SingleNameReference) {
            name = ((SingleNameReference)expression).token;
        }
        if (name != null && (var = this.currentContext.getMember(name)) instanceof AbstractVariableDeclaration) {
            return (AbstractVariableDeclaration)var;
        }
        return null;
    }

    private void buildDefinedMembers(ProgramElement[] statements, Argument[] arguments) {
        int i;
        if (arguments != null) {
            i = 0;
            while (i < arguments.length) {
                this.currentContext.addMember(arguments[i].name, arguments[i]);
                ++i;
            }
        }
        if (statements != null) {
            i = 0;
            while (i < statements.length) {
                if (statements[i] instanceof LocalDeclaration) {
                    LocalDeclaration local = (LocalDeclaration)statements[i];
                    this.currentContext.addMember(local.name, local);
                } else if (statements[i] instanceof AbstractMethodDeclaration) {
                    AbstractMethodDeclaration method = (AbstractMethodDeclaration)statements[i];
                    if (method.selector != null) {
                        this.currentContext.addMember(method.selector, method);
                    }
                }
                ++i;
            }
        }
    }

    private static boolean isThis(Expression expression) {
        return expression instanceof FieldReference && ((FieldReference)expression).receiver.isThis();
    }

    private InferredType getInferredType(Expression expression) {
        char[] possibleTypeName;
        InferredType type = null;
        if (expression instanceof ThisReference) {
            type = this.currentContext.currentType;
        } else if (expression instanceof SingleNameReference) {
            AbstractVariableDeclaration varDecl;
            char[] possibleTypeName2 = this.constructTypeName(expression);
            if (possibleTypeName2 != null && (type = this.compUnit.findInferredType(possibleTypeName2)) == null && (varDecl = this.getVariable(expression)) != null) {
                type = varDecl.inferredType;
            }
        } else if (expression instanceof FieldReference && (possibleTypeName = this.constructTypeName(expression)) != null && (type = this.compUnit.findInferredType(possibleTypeName)) == null) {
            InferredAttribute typeAttribute;
            FieldReference fRef = (FieldReference)expression;
            InferredType parentType = this.getInferredType(fRef.receiver);
            if (parentType != null && (typeAttribute = parentType.findAttribute(fRef.token)) != null) {
                type = typeAttribute.type;
            }
        }
        return type;
    }

    protected final char[] constructTypeName(Expression expression) {
        return Util.getTypeName(expression);
    }

    static class Context {
        InferredType currentType;
        MethodDeclaration currentMethod;
        private HashtableOfObject definedMembers;
        private Context parent = null;

        Context() {
        }

        Context(Context parent) {
            this.parent = parent;
            this.currentType = parent.currentType;
            this.currentMethod = parent.currentMethod;
        }

        public Object getMember(char[] key) {
            Object value = null;
            if (this.definedMembers != null) {
                value = this.definedMembers.get(key);
            }
            if (value == null && this.parent != null) {
                value = this.parent.getMember(key);
            }
            return value;
        }

        public void addMember(char[] key, Object member) {
            if (this.definedMembers == null) {
                this.definedMembers = new HashtableOfObject();
            }
            this.definedMembers.put(key, member);
        }
    }
}

