/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.infer.InferredMember;
import org.eclipse.wst.jsdt.internal.infer.InferredType;

public class InferredMethod
extends InferredMember {
    public MethodDeclaration methodDeclaration;
    public boolean isConstructor;
    public MethodBinding methodBinding;

    public InferredMethod(char[] name, MethodDeclaration methodDeclaration, InferredType inType) {
        this.methodDeclaration = methodDeclaration;
        this.name = name;
        this.inType = inType;
        this.sourceStart = methodDeclaration.sourceStart;
        this.sourceEnd = methodDeclaration.sourceEnd;
    }

    public StringBuffer print(int indent, StringBuffer output) {
        String modifier = this.isStatic ? "static " : "";
        InferredMethod.printIndent(indent, output).append(modifier);
        if (!this.isConstructor) {
            if (this.methodDeclaration.inferredType != null) {
                this.methodDeclaration.inferredType.dumpReference(output);
            } else {
                output.append("??");
            }
            output.append(" ");
        }
        output.append(this.name).append("(");
        if (this.methodDeclaration.arguments != null) {
            int i = 0;
            while (i < this.methodDeclaration.arguments.length) {
                InferredType argumentType;
                if (i > 0) {
                    output.append(", ");
                }
                if ((argumentType = this.methodDeclaration.arguments[i].inferredType) != null) {
                    output.append(argumentType.name).append(" ");
                }
                output.append(this.methodDeclaration.arguments[i].name);
                ++i;
            }
        }
        output.append(")");
        return output;
    }
}

