/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.ASTNode;
import org.eclipse.wst.jsdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BlockScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ClassScope;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.wst.jsdt.internal.compiler.util.HashtableOfObject;
import org.eclipse.wst.jsdt.internal.infer.InferredAttribute;
import org.eclipse.wst.jsdt.internal.infer.InferredMethod;

public class InferredType
extends ASTNode {
    char[] name;
    public ArrayList methods;
    public InferredAttribute[] attributes = new InferredAttribute[5];
    public int numberAttributes = 0;
    HashtableOfObject attributesHash = new HashtableOfObject();
    public InferredType superClass;
    public InferredType referenceClass;
    public SourceTypeBinding binding;
    public boolean isDefinition;
    private TypeBinding resolvedType;
    public ClassScope scope;
    ReferenceBinding resolvedSuperType;
    public boolean isAnonymous = false;
    public static final char[] OBJECT_NAME = new char[]{'O', 'b', 'j', 'e', 'c', 't'};
    public static final char[] OBJECT_LITERAL_NAME = new char[]{'{', '}'};
    public static final char[] ARRAY_NAME = new char[]{'A', 'r', 'r', 'a', 'y'};
    public static final char[] GLOBAL_NAME = new char[]{'G', 'l', 'o', 'b', 'a', 'l'};

    public InferredType(char[] className) {
        this.name = className;
    }

    public char[] getName() {
        return this.name;
    }

    public char[] getSuperClassName() {
        return this.superClass != null ? this.superClass.getName() : OBJECT_NAME;
    }

    public InferredAttribute addAttribute(char[] name, ASTNode definer) {
        InferredAttribute attribute = this.findAttribute(name);
        if (attribute == null) {
            attribute = new InferredAttribute(name, this, definer.sourceStart, definer.sourceEnd);
            if (this.numberAttributes == this.attributes.length) {
                this.attributes = new InferredAttribute[this.numberAttributes * 2];
                System.arraycopy(this.attributes, 0, this.attributes, 0, this.numberAttributes);
            }
            this.attributes[this.numberAttributes++] = attribute;
            this.attributesHash.put(name, attribute);
            if (!this.isAnonymous) {
                this.updatePositions(definer.sourceStart, definer.sourceEnd);
            }
        }
        return attribute;
    }

    public InferredAttribute findAttribute(char[] name) {
        return (InferredAttribute)this.attributesHash.get(name);
    }

    public InferredMethod addMethod(char[] methodName, MethodDeclaration methodDeclaration) {
        InferredMethod method = this.findMethod(methodName, methodDeclaration);
        if (method == null) {
            method = new InferredMethod(methodName, methodDeclaration, this);
            if (this.methods == null) {
                this.methods = new ArrayList();
            }
            this.methods.add(method);
            if (!this.isAnonymous) {
                this.updatePositions(methodDeclaration.sourceStart, methodDeclaration.sourceEnd);
            }
        }
        methodDeclaration.inferredMethod = method;
        return method;
    }

    public InferredMethod findMethod(char[] methodName, MethodDeclaration methodDeclaration) {
        if (methodName == TypeConstants.INIT) {
            methodName = this.name;
        }
        if (this.methods != null) {
            Iterator methodIterator = this.methods.iterator();
            while (methodIterator.hasNext()) {
                InferredMethod method = (InferredMethod)methodIterator.next();
                if (!CharOperation.equals(methodName, method.name)) continue;
                return method;
            }
        }
        return null;
    }

    public TypeBinding resolveType(BlockScope scope, ASTNode node) {
        if (this.resolvedType != null) {
            return this.resolvedType.isValidBinding() ? this.resolvedType : null;
        }
        if (this.isArray()) {
            TypeBinding memberType;
            TypeBinding typeBinding = memberType = this.referenceClass != null ? this.referenceClass.resolveType(scope, node) : null;
            if (memberType == null) {
                memberType = TypeBinding.UNKNOWN;
            }
            this.resolvedType = new ArrayBinding(memberType, 1, scope.compilationUnitScope().environment);
        } else {
            this.resolvedType = scope.getType(this.name);
            if (!this.resolvedType.isValidBinding()) {
                this.resolvedType = null;
            }
        }
        if (this.resolvedType == null) {
            return null;
        }
        if (!this.resolvedType.isValidBinding()) {
            scope.problemReporter().invalidType(node, this.resolvedType);
            return null;
        }
        if (node.isTypeUseDeprecated(this.resolvedType, scope)) {
            scope.problemReporter().deprecatedType(this.resolvedType, node);
        }
        this.resolvedType = scope.environment().convertToRawType(this.resolvedType);
        if (this.isAnonymous) {
            this.resolvedType.tagBits |= 0x34L;
        }
        return this.resolvedType;
    }

    public void dumpReference(StringBuffer sb) {
        sb.append(this.name);
        if (this.referenceClass != null) {
            sb.append('(');
            this.referenceClass.dumpReference(sb);
            sb.append(')');
        }
    }

    public boolean containsMethod(AbstractMethodDeclaration inMethod) {
        if (this.methods != null) {
            Iterator iter = this.methods.iterator();
            while (iter.hasNext()) {
                InferredMethod method = (InferredMethod)iter.next();
                if (method.methodDeclaration != inMethod) continue;
                return true;
            }
        }
        return false;
    }

    public ReferenceBinding resolveSuperType(ClassScope classScope) {
        if (this.resolvedSuperType != null) {
            return this.resolvedSuperType;
        }
        this.resolvedSuperType = (ReferenceBinding)classScope.getType(this.name);
        return this.resolvedSuperType;
    }

    public boolean isArray() {
        return ARRAY_NAME.equals(this.name);
    }

    public StringBuffer print(int indent, StringBuffer output) {
        InferredType.printIndent(indent, output);
        char[] superName = this.getSuperClassName();
        output.append("class ").append(this.name).append(" extends ").append(superName).append("{\n");
        int i = 0;
        while (i < this.numberAttributes) {
            this.attributes[i].print(indent + 1, output);
            output.append(";\n");
            ++i;
        }
        if (this.methods != null) {
            Iterator methodIterator = this.methods.iterator();
            while (methodIterator.hasNext()) {
                InferredMethod method = (InferredMethod)methodIterator.next();
                method.print(indent + 1, output);
                output.append("\n");
            }
        }
        output.append("}");
        return output;
    }

    public boolean isInferred() {
        return true;
    }

    public void updatePositions(int start, int end) {
        if (start >= 0 && start < this.sourceStart) {
            this.sourceStart = start;
        }
        if (end > 0 && end > this.sourceEnd) {
            this.sourceEnd = end;
        }
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            int i = 0;
            int max = this.methods.size();
            while (i < max) {
                InferredMethod method = (InferredMethod)this.methods.get(i);
                if (method.methodBinding == methodBinding) {
                    return method.methodDeclaration;
                }
                ++i;
            }
        }
        return null;
    }
}

