/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.infer;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.internal.infer.DefaultInferrenceProvider;
import org.eclipse.wst.jsdt.internal.infer.InferrenceProvider;
import org.eclipse.wst.jsdt.internal.infer.InferrenceSupportExtension;

public class InferrenceManager {
    public static final String EXTENSION_POINT = "inferrenceSupport";
    protected static final String TAG_INFERENGINE = "inferenceEngine";
    protected static final String ATTR_INFERENGINE_CLASS = "class";
    private static InferrenceManager instance = null;
    private InferrenceSupportExtension[] extensions;

    public static InferrenceManager getInstance() {
        if (instance == null) {
            instance = new InferrenceManager();
        }
        return instance;
    }

    public InferrenceProvider[] getInferenceProviders() {
        if (this.extensions == null) {
            this.loadInferenceExtensions();
        }
        ArrayList<InferrenceProvider> extProviders = new ArrayList<InferrenceProvider>();
        extProviders.add(new DefaultInferrenceProvider());
        int i = 0;
        while (i < this.extensions.length) {
            if (this.extensions[i].inferProvider != null) {
                extProviders.add(this.extensions[i].inferProvider);
            }
            ++i;
        }
        return extProviders.toArray(new InferrenceProvider[extProviders.size()]);
    }

    protected void loadInferenceExtensions() {
        IExtensionPoint point;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<InferrenceSupportExtension> extList = new ArrayList<InferrenceSupportExtension>();
        if (registry != null && (point = registry.getExtensionPoint("org.eclipse.wst.jsdt.core", EXTENSION_POINT)) != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    try {
                        InferrenceProvider inferProvider = null;
                        if (elements[j].getName().equals(TAG_INFERENGINE)) {
                            inferProvider = (InferrenceProvider)elements[j].createExecutableExtension(ATTR_INFERENGINE_CLASS);
                        }
                        InferrenceSupportExtension inferenceSupport = new InferrenceSupportExtension();
                        inferenceSupport.inferProvider = inferProvider;
                        extList.add(inferenceSupport);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++j;
                }
                ++i;
            }
        }
        this.extensions = extList.toArray(new InferrenceSupportExtension[extList.size()]);
    }
}

