/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.launching;

import com.ibm.icu.text.MessageFormat;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.IAccessRule;
import org.eclipse.wst.jsdt.core.IClasspathAttribute;
import org.eclipse.wst.jsdt.core.IClasspathContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.launching.IVMInstall;
import org.eclipse.wst.jsdt.launching.JavaRuntime;
import org.eclipse.wst.jsdt.launching.LaunchingMessages;
import org.eclipse.wst.jsdt.launching.LibraryLocation;

public class JREContainer
implements IClasspathContainer {
    private IVMInstall fVMInstall = null;
    private IPath fPath = null;
    private static Map fgClasspathEntries = null;
    private static IAccessRule[] EMPTY_RULES = new IAccessRule[0];

    private static IClasspathEntry[] getClasspathEntries(IVMInstall vm) {
        IClasspathEntry[] entries;
        if (fgClasspathEntries == null) {
            fgClasspathEntries = new HashMap(10);
        }
        if ((entries = (IClasspathEntry[])fgClasspathEntries.get(vm)) == null) {
            entries = JREContainer.computeClasspathEntries(vm);
            fgClasspathEntries.put(vm, entries);
        }
        return entries;
    }

    private static IClasspathEntry[] computeClasspathEntries(IVMInstall vm) {
        LibraryLocation[] libs = vm.getLibraryLocations();
        boolean overrideJavaDoc = false;
        if (libs == null) {
            libs = JavaRuntime.getLibraryLocations(vm);
            overrideJavaDoc = true;
        }
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(libs.length);
        int i = 0;
        while (i < libs.length) {
            if (!libs[i].getSystemLibraryPath().isEmpty()) {
                IPath rootPath;
                IPath sourcePath = libs[i].getSystemLibrarySourcePath();
                if (sourcePath.isEmpty()) {
                    sourcePath = null;
                }
                if ((rootPath = libs[i].getPackageRootPath()).isEmpty()) {
                    rootPath = null;
                }
                URL javadocLocation = libs[i].getJavadocLocation();
                if (overrideJavaDoc && javadocLocation == null) {
                    javadocLocation = vm.getJavadocLocation();
                }
                IClasspathAttribute[] attributes = null;
                attributes = javadocLocation == null ? new IClasspathAttribute[]{} : new IClasspathAttribute[]{JavaCore.newClasspathAttribute("javadoc_location", javadocLocation.toExternalForm())};
                entries.add(JavaCore.newLibraryEntry(libs[i].getSystemLibraryPath(), sourcePath, rootPath, EMPTY_RULES, attributes, false));
            }
            ++i;
        }
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    public JREContainer(IVMInstall vm, IPath path) {
        this.fVMInstall = vm;
        this.fPath = path;
    }

    public IClasspathEntry[] getClasspathEntries() {
        return JREContainer.getClasspathEntries(this.fVMInstall);
    }

    public String getDescription() {
        return MessageFormat.format((String)LaunchingMessages.JREContainer_JRE_System_Library_1, (Object[])new String[0]);
    }

    public int getKind() {
        return 3;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public String[] resolvedLibraryImport(String a) {
        return null;
    }
}

