/*******************************************************************************
 * Copyright (c) 2005 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
/*
 *  $RCSfile: ExceptionHandler.java,v $
 *  $Revision: 1.2 $  $Date: 2005/12/14 19:06:13 $ 
 */
package org.eclipse.jem.internal.beaninfo.ui;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

import org.eclipse.jem.internal.ui.core.JEMUIPlugin;
 
/**
 * 
 * 
 * @since 1.2.0
 */
public class ExceptionHandler {

	/**
	 * 
	 * @param e
	 * @param shell
	 * @param title
	 * @param message
	 * 
	 * @since 1.2.0
	 */
	public static void handle(InvocationTargetException e, Shell shell, String title, String message) {
		Throwable target= e.getTargetException();
		if (target instanceof CoreException) {
			handle((CoreException)target, shell, title, message);
		} else {
			JEMUIPlugin.getPlugin().getLogger().log(e);
			if (e.getMessage() != null && e.getMessage().length() > 0) {
				displayMessageDialog(e, e.getMessage(), shell, title, message);
			} else {
				displayMessageDialog(e, target.getMessage(), shell, title, message);
			}
		}
	}
	
	public static void handle(CoreException e, Shell shell, String title, String message) {
		JEMUIPlugin.getPlugin().getLogger().log(e);
		IStatus status= e.getStatus();
		if (status != null) {
			ErrorDialog.openError(shell, title, message, status);
		} else {
			displayMessageDialog(e, e.getMessage(), shell, title, message);
		}
	}
	
	private static void displayMessageDialog(Throwable t, String exceptionMessage, Shell shell, String title, String message) {
		StringWriter msg= new StringWriter();
		if (message != null) {
			msg.write(message);
			msg.write("\n\n"); //$NON-NLS-1$
		}
		if (exceptionMessage == null || exceptionMessage.length() == 0)
			msg.write(BeanInfoUIMessages.ExceptionHandler_errordialog_msg_seelog); 
		else
			msg.write(exceptionMessage);
		MessageDialog.openError(shell, title, msg.toString());			
	}	

}
