/**
 * <copyright>
 *
 * Copyright (c) 2006, 2007 IBM Corporation and others.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *   IBM - Initial API and implementation
 *
 * </copyright>
 *
 * $Id: PersistentEnvironment.java,v 1.3 2007/10/11 23:05:16 cdamus Exp $
 */
package org.eclipse.emf.ocl.parser;

import org.eclipse.emf.ocl.expressions.Variable;

/**
 * An OCL environment that supports persistence of the dynamically-generated
 * bindings of generic types, based on the classifiers provided by the
 * environment.  The persistent environment must:
 * <ul>
 *   <li>define a {@link TypeResolver} that provides a canonical mapping of
 *       types generated by the parser to types in a resource that the client
 *       can persist as needed</li>
 *   <li>ensure that any {@link Variable}s defined in the environment can
 *       also be referenced by a persisted expression</li>
 * </ul>
 * <p>
 * This interface is <b>not</b> intended to be implemented by clients "directly".
 * It is highly recommended to extend the {@link EcoreEnvironment} class,
 * instead.
 * </p>
 *
 * @deprecated Use the {@link org.eclipse.ocl.Environment} interface,
 * instead.
 * 
 * @author Christian W. Damus (cdamus)
 */
@Deprecated
public interface PersistentEnvironment extends Environment {
	/**
	 * Obtains a type resolver to be used to create (and cache) concrete bindings
	 * for the generic OCL types, based on the user model types provided by this
	 * environment.
	 * 
	 * @return the type resolver
	 */
	public TypeResolver getTypeResolver();

}
