/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.stp.bpmn.BpmnMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DirectionType implements Enumerator
{
    NONE_LITERAL(0, BpmnMessages.DirectionType_None, "None"),
    TO_LITERAL(1, BpmnMessages.DirectionType_To, "To"),
    FROM_LITERAL(2, BpmnMessages.DirectionType_From, "From"),
    BOTH_LITERAL(3, BpmnMessages.DirectionType_Both, "Both");

    public static final int NONE = 0;
    public static final int TO = 1;
    public static final int FROM = 2;
    public static final int BOTH = 3;
    private static final DirectionType[] VALUES_ARRAY;
    public static final List<DirectionType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DirectionType[]{NONE_LITERAL, TO_LITERAL, FROM_LITERAL, BOTH_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DirectionType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DirectionType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DirectionType get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return TO_LITERAL;
            }
            case 2: {
                return FROM_LITERAL;
            }
            case 3: {
                return BOTH_LITERAL;
            }
        }
        return null;
    }

    private DirectionType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

