/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.commands.ElementTypeEx;
import org.eclipse.stp.bpmn.diagram.BpmnDiagramMessages;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.BpmnShapesDefaultSizes;
import org.eclipse.stp.bpmn.policies.ResizableShapeEditPolicyEx;
import org.eclipse.stp.bpmn.tools.ActivityResizeTracker;
import org.eclipse.stp.bpmn.tools.TaskDragEditPartsTrackerEx;

public class ResizableActivityEditPolicy
extends ResizableShapeEditPolicyEx {
    protected Handle createHandle(org.eclipse.gef.GraphicalEditPart owner, int direction) {
        return new ActivityResizeHandle(owner, direction);
    }

    protected void replaceHandleDragEditPartsTracker(Handle handle) {
        if (handle instanceof AbstractHandle) {
            AbstractHandle h = (AbstractHandle)handle;
            h.setDragTracker((DragTracker)new TaskDragEditPartsTrackerEx((IGraphicalEditPart)this.getHost()));
        }
    }

    protected Command getAutoSizeCommand(Request request) {
        IGraphicalEditPart nameEp;
        EObject semantic = ((IGraphicalEditPart)this.getHost()).resolveSemanticElement();
        Object type = ElementTypeRegistry.getInstance().getElementType(semantic);
        if (semantic instanceof Activity) {
            type = ElementTypeEx.wrap(type, ((Activity)semantic).getActivityType().getName());
        }
        Dimension size = BpmnShapesDefaultSizes.getDefaultSize(type).getCopy();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Rectangle rect = new Rectangle(this.getHostFigure().getBounds().getLocation().getCopy(), size);
        if ((ActivityType.VALUES_EVENTS.contains(((Activity)semantic).getActivityType()) || ActivityType.VALUES_GATEWAYS.contains(((Activity)semantic).getActivityType())) && (nameEp = ((IGraphicalEditPart)this.getHost()).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4001))) == null) {
            nameEp = ((IGraphicalEditPart)this.getHost()).getChildBySemanticHint(BpmnVisualIDRegistry.getType(4002));
        }
        SetBoundsCommand resizeCommand = new SetBoundsCommand(editingDomain, "", (IAdaptable)((GraphicalEditPart)this.getHost()), rect);
        return new ICommandProxy((ICommand)resizeCommand);
    }

    public Command getCommand(Request request) {
        if ("resize children".equals(request.getType())) {
            TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
            final ChangeBoundsRequest change = (ChangeBoundsRequest)request;
            final IGraphicalEditPart nameEp = (IGraphicalEditPart)change.getEditParts().iterator().next();
            SetBoundsCommand resize = new SetBoundsCommand(editingDomain, BpmnDiagramMessages.ResizableActivityEditPolicy_command_name, (IAdaptable)nameEp, change.getSizeDelta()){

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    nameEp.getFigure().setSize(nameEp.getFigure().getSize().getCopy().expand(change.getSizeDelta()));
                    return super.doExecuteWithResult(monitor, info);
                }
            };
            ChangeBoundsRequest selfResize = new ChangeBoundsRequest((Object)"resize");
            selfResize.setEditParts(this.getHost());
            selfResize.setSizeDelta(change.getSizeDelta().getCopy());
            CompoundCommand compound = new CompoundCommand();
            compound.add((Command)new ICommandProxy((ICommand)resize));
            compound.add(super.getCommand((Request)selfResize));
            return compound;
        }
        return super.getCommand(request);
    }

    protected static class ActivityResizeHandle
    extends ResizableShapeEditPolicyEx.ResizeHandleEx {
        public ActivityResizeHandle(org.eclipse.gef.GraphicalEditPart owner, int direction) {
            super(owner, direction);
        }

        protected DragTracker createDragTracker() {
            return new ActivityResizeTracker(this.getOwner(), this.cursorDirection);
        }
    }
}

