/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.util.Assert;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.ISupportedTechnologyType;
import org.eclipse.stp.soas.deploy.core.ITechnologyDefinition;
import org.eclipse.stp.soas.deploy.core.ITechnologyType;
import org.eclipse.stp.soas.deploy.core.IVersion;
import org.eclipse.stp.soas.deploy.core.Version;
import org.eclipse.stp.soas.internal.deploy.core.PackageExtensionException;

public class SupportedTechnologyType
implements ISupportedTechnologyType {
    public static final String ATTR_TYPE = "type";
    public static final String ATTR_MIN_VERSION = "minVersion";
    public static final String ATTR_MAX_VERSION = "maxVersion";
    private IConfigurationElement mElement;
    private String mTechnologyDef;
    private IVersion mMinVersion;
    private IVersion mMaxVersion;

    public SupportedTechnologyType(IConfigurationElement element) throws PackageExtensionException {
        this.init(element);
    }

    public ITechnologyDefinition getTechnologyDefinition() {
        return DeploymentExtensionManager.getInstance().getTechnologyDefinition(this.mTechnologyDef);
    }

    public IVersion getMinVersion() {
        return this.mMinVersion;
    }

    public IVersion getMaxVersion() {
        return this.mMaxVersion;
    }

    public boolean supportsTechnology(ITechnologyType type) {
        IVersion typeVersion = type.getVersion();
        boolean retVal = type.getTechnologyDefinition().equals(this.getTechnologyDefinition()) && typeVersion.compareTo(this.getMaxVersion()) <= 0 && typeVersion.compareTo(this.getMinVersion()) >= 0;
        return retVal;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.mMinVersion.equals(this.mMaxVersion)) {
            buf.append(this.mMinVersion);
        } else {
            buf.append(this.mMinVersion).append('-').append(this.mMaxVersion);
        }
        return DeployCorePlugin.getDefault().getResourceString("SupportedTechnologyType.toString", new Object[]{this.mTechnologyDef, buf.toString()});
    }

    private void init(IConfigurationElement element) throws PackageExtensionException {
        Assert.isTrue((boolean)"supportedTechnology".equals(element.getName()));
        if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.out.println(DeployCorePlugin.getDefault().getResourceString("SupportedTechnologyType.trace.processingSupportedTechnologyElement", new Object[]{element.getDeclaringExtension().getContributor().getName(), ((IConfigurationElement)element.getParent()).getName()}));
            System.out.flush();
        }
        boolean error = false;
        this.mElement = element;
        this.mTechnologyDef = this.mElement.getAttribute(ATTR_TYPE);
        this.mMinVersion = Version.valueOf(this.mElement.getAttribute(ATTR_MIN_VERSION));
        this.mMaxVersion = Version.valueOf(this.mElement.getAttribute(ATTR_MAX_VERSION));
        if (this.mTechnologyDef == null) {
            error = true;
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedTechnologyType.trace.error.typeNotSpecified"));
                System.err.flush();
            }
        } else if (DeploymentExtensionManager.getInstance().getTechnologyDefinition(this.mTechnologyDef) == null) {
            error = true;
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedTechnologyType.trace.error.invalidTypeSpecified"));
                System.err.flush();
            }
        }
        if (this.mMinVersion.compareTo(this.mMaxVersion) > 0) {
            error = true;
            if (DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
                System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedTechnologyType.trace.error.minVersionGreaterThanMaxVersion"));
                System.err.flush();
            }
        } else if (this.mMaxVersion.compareTo(Version.NULL_VERSION) == 0 && DeploymentExtensionManager.DEBUG_DEPLOYMENT_EXTENSION) {
            System.err.println(DeployCorePlugin.getDefault().getResourceString("SupportedTechnologyType.trace.versionNotSpecified"));
            System.err.flush();
        }
        if (error) {
            throw new PackageExtensionException(DeployCorePlugin.getDefault().getResourceString("SupportedTechnologyType.exception.supportedTechnologyParseError"));
        }
    }
}

