/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.soas.internal.deploy.ui.properties;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.internal.deploy.ui.dialogs.FolderSelectionDialog;
import org.eclipse.stp.soas.internal.deploy.ui.properties.DeploymentResource;
import org.eclipse.stp.soas.internal.deploy.ui.properties.ProjectFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DeployOutputFolderPropertyPage
extends PropertyPage {
    private IProject project = null;
    private Text outputFolderText = null;
    private DeploymentResource deploymentResource = null;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite content = new Composite(parent, 0);
        GridData data = new GridData(1808);
        content.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(1, false);
        content.setLayout((Layout)layout);
        Label label = new Label(content, 0);
        label.setText(DeployCorePlugin.getDefault().getResourceString("LABEL.DefineDefaultFolder"));
        Composite blockComposite = new Composite(content, 0);
        blockComposite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout = new GridLayout(2, false);
        blockComposite.setLayout((Layout)gridLayout);
        this.outputFolderText = new Text(blockComposite, 2052);
        this.outputFolderText.setLayoutData((Object)new GridData(768));
        this.outputFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeployOutputFolderPropertyPage.this.validateChange(e);
            }
        });
        Button button = new Button(blockComposite, 8);
        button.setText(DeployCorePlugin.getDefault().getResourceString("Button.Browse"));
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeployOutputFolderPropertyPage.this.chooseFolder(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                DeployOutputFolderPropertyPage.this.chooseFolder(e);
            }
        });
        this.initailOutputFolder();
        return content;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        if (element instanceof IProject) {
            IProject aproject;
            this.project = aproject = (IProject)element;
            this.deploymentResource = new DeploymentResource(this.project);
        }
    }

    private void validateChange(ModifyEvent e) {
        IPath outputFolderPath;
        Text text = (Text)e.widget;
        String outputFolder = text.getText();
        if (outputFolder == null || outputFolder.trim().length() == 0) {
            this.setErrorMessage(DeployCorePlugin.getDefault().getResourceString("DeploymentOutputFolderPage.error.emptyPath"));
            this.setValid(false);
            return;
        }
        IPath projectPath = this.project.getFullPath();
        if (!projectPath.isPrefixOf(outputFolderPath = new Path(outputFolder).makeAbsolute()) || projectPath.equals((Object)outputFolderPath)) {
            String name = this.project.getName();
            this.setErrorMessage(DeployCorePlugin.getDefault().getResourceString("DeploymentOutputFolderPage.error.invalidPath", new Object[]{outputFolder, name}));
            this.setValid(false);
            return;
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }

    private void chooseFolder(SelectionEvent e) {
        ContainerContentProvider cp = new ContainerContentProvider();
        cp.showClosedProjects(false);
        FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)cp);
        dialog.setTitle(DeployCorePlugin.getDefault().getResourceString("FolderSelectionDialog.TITLE"));
        dialog.setMessage(DeployCorePlugin.getDefault().getResourceString("FolderSelectionDialog.MESSAGE"));
        IWorkspaceRoot root = this.project.getWorkspace().getRoot();
        IProject[] allProjects = root.getProjects();
        ArrayList<IProject> rejectedElements = new ArrayList<IProject>();
        int i = 0;
        while (i < allProjects.length) {
            if (!allProjects[i].equals((Object)this.project)) {
                rejectedElements.add(allProjects[i]);
            }
            ++i;
        }
        dialog.addFilter(new ProjectFilter(rejectedElements.toArray(), new Class[]{IProject.class, IFolder.class}));
        dialog.setInput(this.project.getWorkspace().getRoot());
        IContainer initialSel = this.getInitialSelecionForDialog();
        if (initialSel != null) {
            dialog.setInitialSelection(initialSel);
        }
        if (dialog.open() == 0) {
            IContainer selection = (IContainer)dialog.getFirstResult();
            this.outputFolderText.setText(selection.getFullPath().toString());
        }
    }

    private IContainer getInitialSelecionForDialog() {
        String text = this.outputFolderText.getText();
        IWorkspaceRoot workspaceRoot = this.project.getWorkspace().getRoot();
        IResource initSelection = workspaceRoot.findMember(text);
        if (initSelection instanceof IContainer) {
            return (IContainer)initSelection;
        }
        return null;
    }

    private void initailOutputFolder() {
        String outputFolder = this.deploymentResource.getOutputFolder();
        if (outputFolder != null) {
            this.outputFolderText.setText(outputFolder);
        }
    }

    public boolean performOk() {
        String oldOutputFolder;
        IPath oldFolderPath;
        IPath destFolderPath;
        String folderText = this.outputFolderText.getText();
        IWorkspaceRoot workspaceRoot = this.project.getWorkspace().getRoot();
        IFolder destFolder = workspaceRoot.getFolder(destFolderPath = workspaceRoot.getFullPath().append(folderText));
        if (destFolder == null || !destFolder.getLocation().toFile().exists()) {
            try {
                Utilities.createFolder(destFolder, true, true);
            }
            catch (CoreException e) {
                MessageDialog.openError(null, (String)DeployCorePlugin.getDefault().getResourceString("DeploymentOutputFolderPage.moveFolderDialog.title"), (String)e.getMessage());
            }
        }
        if (!(oldFolderPath = new Path(oldOutputFolder = this.deploymentResource.getOutputFolder()).makeAbsolute()).equals((Object)destFolderPath)) {
            IFolder oldFolder;
            String message = DeployCorePlugin.getDefault().getResourceString("DeploymentOutputFolderPage.message.moveFolder", new Object[]{oldOutputFolder});
            String title = DeployCorePlugin.getDefault().getResourceString("DeploymentOutputFolderPage.moveFolderDialog.title");
            boolean moveFiles = MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message);
            if (moveFiles && (oldFolder = workspaceRoot.getFolder(oldFolderPath)).exists()) {
                try {
                    Utilities.moveFolder(oldFolder, destFolder, "svcpkg", false);
                }
                catch (CoreException e) {
                    MessageDialog.openError(null, (String)DeployCorePlugin.getDefault().getResourceString("DeploymentOutputFolderPage.moveFolderDialog.title"), (String)e.getMessage());
                }
            }
        }
        this.deploymentResource.setOutputFolder(this.outputFolderText.getText().trim());
        return super.performOk();
    }

    public static File getOutputFolder(IProject project) {
        DeploymentResource resource = new DeploymentResource(project);
        String folderPath = resource.getOutputFolder();
        IFolder folder = project.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        if (!folder.exists()) {
            try {
                Utilities.createFolder(folder, true, true);
            }
            catch (CoreException e) {
                System.err.println(e.getMessage());
            }
        }
        return new File(folder.getRawLocation().toOSString());
    }

    public static String getOutputContainerPath(IProject project) {
        DeploymentResource resource = new DeploymentResource(project);
        String folderPath = resource.getOutputFolder();
        return folderPath;
    }
}

