/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sc.jaxws.wizards.annotations;

import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class AttributeControlProxy {
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_STRING = 0;
    public static final int TYPE_BOOLEAN = 1;
    public static final int TYPE_ENUM = 2;
    static final String STR_FALSE = "false";
    static final String STR_TRUE = "true";
    static final String STR_EMPTY = "";
    static final String[] COMBO_VAL_BOOLEAN = new String[]{"", "true", "false"};
    private int type;
    private String name;
    private Control control;

    private AttributeControlProxy(int aType, String aName, Control aValue) {
        this.type = aType;
        this.name = aName;
        this.control = aValue;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Control getControl() {
        return this.control;
    }

    public static AttributeControlProxy createInstance(Group parentContainer, String attributeName, Class attributeTypeClass, ModifyListener listener) {
        Control attributeWidget;
        int attributeType;
        if (attributeTypeClass.equals(Boolean.TYPE)) {
            attributeType = 1;
            attributeWidget = AttributeControlProxy.createControlForBooleanAttribute(parentContainer, listener);
        } else if (attributeTypeClass.isEnum()) {
            attributeType = 2;
            attributeWidget = AttributeControlProxy.createControlForEnumAttribute(parentContainer, attributeTypeClass, listener);
        } else {
            attributeType = 0;
            attributeWidget = AttributeControlProxy.createControlForTextAttribute(parentContainer, listener);
        }
        AttributeControlProxy attrib = new AttributeControlProxy(attributeType, attributeName, attributeWidget);
        return attrib;
    }

    public void setControlValue(MemberValuePair newValue) {
        String strValue;
        String string = strValue = newValue == null ? null : newValue.getValue().toString();
        if (strValue != null && strValue.length() != 0) {
            if (strValue.indexOf(34) == 0) {
                strValue = strValue.substring(1, strValue.length() - 1);
            }
            if (this.type == 0) {
                ((Text)this.getControl()).setText(strValue);
            } else if (this.type == 1 || this.type == 2) {
                String[] items = ((Combo)this.getControl()).getItems();
                int comboIndex = 0;
                while (comboIndex < items.length) {
                    if (items[comboIndex].equals(strValue)) {
                        ((Combo)this.getControl()).select(comboIndex);
                        break;
                    }
                    ++comboIndex;
                }
            }
        }
    }

    public void clearControlValue() {
        if (this.type == 0) {
            ((Text)this.getControl()).setText(STR_EMPTY);
        } else if (this.type == 1 || this.type == 2) {
            ((Combo)this.getControl()).clearSelection();
        }
    }

    public Object getControlValue() {
        Object controlValue = null;
        if (this.type == 0) {
            String strValue = ((Text)this.getControl()).getText();
            if (strValue != null && strValue.length() != 0) {
                controlValue = strValue;
            }
        } else if (this.type == 1) {
            String strValue = ((Combo)this.getControl()).getText();
            controlValue = STR_TRUE.equals(strValue);
        } else if (this.type == 2) {
            String strValue = ((Combo)this.getControl()).getText();
            controlValue = strValue;
        }
        return controlValue;
    }

    private static Control createControlForEnumAttribute(Group grpAttrib, Class returnTypeClass, ModifyListener listener) {
        Combo comboEnums = new Combo((Composite)grpAttrib, 12);
        T[] enumsConstants = returnTypeClass.getEnumConstants();
        String[] comboValues = new String[enumsConstants.length];
        int i = 0;
        while (i < enumsConstants.length) {
            comboValues[i] = enumsConstants[i].toString();
            ++i;
        }
        comboEnums.setItems(comboValues);
        comboEnums.addModifyListener(listener);
        return comboEnums;
    }

    private static Control createControlForBooleanAttribute(Group grpAttrib, ModifyListener listener) {
        Combo comboBoolean = new Combo((Composite)grpAttrib, 12);
        comboBoolean.setItems(COMBO_VAL_BOOLEAN);
        comboBoolean.addModifyListener(listener);
        return comboBoolean;
    }

    private static Control createControlForTextAttribute(Group grpAttrib, ModifyListener listener) {
        Text txtCtrl = new Text((Composite)grpAttrib, 2052);
        txtCtrl.addModifyListener(listener);
        return txtCtrl;
    }
}

