/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.common.logging;



public class SystemOutWriter implements ILogWriter {
    
    private static final String PREFIX_DEBUG = "DEBUG";
    private static final String PREFIX_INFO = "INFO";
    private static final String PREFIX_ERROR = "ERROR";

    private Class logRoot;
    
    public SystemOutWriter(Class aLogRoot) {
        logRoot = aLogRoot;
    }

    public void debug(Object message, Throwable t) {
        printHeading(PREFIX_DEBUG);
        printMessage(message);
        printStackTrace(t);
    }

    public void debug(Object message) {
        printHeading(PREFIX_DEBUG);
        printMessage(message);
        System.out.println();
    }

    public void error(Object message, Throwable t) {
        printHeading(PREFIX_ERROR);
        printMessage(message);
        printStackTrace(t);
    }

    public void error(Object message) {
        printHeading(PREFIX_ERROR);
        printMessage(message);
        System.out.println();
    }

    public void info(Object message, Throwable t) {
        printHeading(PREFIX_INFO);
        printMessage(message);
        printStackTrace(t);
    }

    public void info(Object message) {
        printHeading(PREFIX_ERROR);
        printMessage(message);
        System.out.println();
    }

    private void printStackTrace(Throwable t) {
        System.out.println();
        t.printStackTrace();
    }

    private void printMessage(Object message) {
        if (message instanceof String) {
            System.out.print((String)message + "  ");
        } else {
            System.out.print(message.toString() + "  ");
        }
    }

    private void printHeading(String prefix) {
        System.out.print(" " + prefix + " -- " + logRoot.getCanonicalName() + " -- ");
    }

}
