/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceException;
import org.eclipse.stp.b2j.core.jengine.internal.compiler.xmlns.NamespaceTranslator;
import org.eclipse.stp.b2j.core.jengine.internal.utils.TranslatorUtils;
import org.eclipse.stp.b2j.core.publicapi.extension.wsdlbinding.XSDTypeTranslator;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Node;
import org.eclipse.stp.b2j.core.xml.internal.w3c.NodeList;

/**
 * 
 * @author amiguel
 *
 * A set of utility methods used by the BPEL/WSDL/XSD/XPATH translator classes
 */
public class Util {
	
private HashMap ncmappings = null;
private HashMap qmappings = null;
private String program_prefix;
private Switches switches;

private HashMap nicepkgs = new HashMap();
private HashMap nicenames = new HashMap();

private HashMap line_hashmap = new HashMap();
private HashMap path_hashmap = new HashMap();
private String bpel_source;

private HashMap xsdTypeDirectAliases = new HashMap();

	public Util(String program_prefix, Switches switches) {
		this.program_prefix = program_prefix;
		this.switches = switches;
	}
	
	public void setBpelSource(String source, Document doc) {
		//TODO
	}
/*	
	public void setBpelSource(String source, Document doc) {
		bpel_source = source;
		
		buildPathMap(doc);
		
		try {
			Transformer tf = TransformerFactory.newInstance().newTransformer();
			tf.setOutputProperty(OutputKeys.INDENT,"no");
	
			LineTracker linetracker = new LineTracker(line_hashmap,path_hashmap);
			SAXSource ssource = new SAXSource(new InputSource(new StringReader(source)));
			SAXResult result = new SAXResult(linetracker);
	
			tf.transform(ssource,result);
		} catch (javax.xml.transform.TransformerException e) {
			e.getException().printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void buildPathMap(Node node) {
		//TODO inefficient!  and should cache line numbers too why not
		try {
			Object stack = getStackTrace(node);
			path_hashmap.put(node,stack);
			path_hashmap.put(stackTraceToString((int[])stack),node);
		} catch (Exception e) {}
		
		NodeList list = node.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			buildPathMap(list.item(i));
		}
	}
	*/
	
	public String getProgramPrefix() {
		return program_prefix;
	}
	
	public NamespaceTranslator createNamespaceTranslator() {
		return new NamespaceTranslator(program_prefix,this);
	}
	
	public void addJavaQNameMapping(String java_qname, String namespace, String name) {
		nicepkgs.put(java_qname,namespace);
		nicenames.put(java_qname,name);
	}
	
	public void setXsdTypeDirectAlias(String qtype_from, String qtype_to) {
		xsdTypeDirectAliases.put(qtype_from, qtype_to);
	}
	public String getXsdTypeDirectAlias(String qtype) {
		return (String)xsdTypeDirectAliases.get(qtype);
	}
	
	public String getQNameFromQName(String java_qname) {
		String tmp = (String)nicepkgs.get(java_qname);
System.out.println("MAPPING FOUND "+java_qname+" "+tmp);
		if (tmp != null) {
			return tmp+":"+nicenames.get(java_qname);
		} else {
			return java_qname;
		}
	}
	
	public Switches getSwitches() {
		return switches;
	}

public static final String plugin_package = "org.eclipse.stp.b2j.core";
public static final String jengine_package = "org.eclipse.stp.b2j.core.jengine.internal";
public static final String jenginec_package = "org.eclipse.stp.b2j.core.jengine.internal.compiler";
	
private static String[][] xsd_mappings = new String[][]
{
	{"xsd:string",null},
	{"xsd:normalizedString","string"},
	{"xsd:token","string"},

	{"xsd:byte","int"},
	{"xsd:unsignedByte","int"},

	{"xsd:base64Binary","string"},
	{"xsd:hexBinary","string"},

	{"xsd:integer","int"},
	{"xsd:positiveInteger","int"},
	{"xsd:negativeInteger","int"},
	{"xsd:nonPositiveInteger","int"},
	{"xsd:nonNegativeInteger","int"},

	{"xsd:int",null},
	{"xsd:unsignedInt","long"},
	{"xsd:long",null},
	{"xsd:unsignedLong","long"},

	{"xsd:short","int"},
	{"xsd:unsignedShort","int"},

	{"xsd:decimal","double"},
	{"xsd:float","double"},
	{"xsd:double",null},

	{"xsd:boolean",null},

	{"xsd:time","date"},
	{"xsd:dateTime","date"},
	{"xsd:duration","long"},
	{"xsd:date",null},

	{"xsd:gMonth","date"},
	{"xsd:gYear","date"},
	{"xsd:gYearMonth","date"},
	{"xsd:gDay","date"},
	{"xsd:gMonthDay","date"},

	{"xsd:Name","string"},
	{"xsd:QName","string"},
	{"xsd:NCName","string"},
	{"xsd:anyURI","string"},
	{"xsd:language","string"},
	{"xsd:ID","string"},
	{"xsd:IDREF","string"},
	{"xsd:IDREFS","string"},
	{"xsd:ENTITY","string"},
	{"xsd:ENTITIES","string"},
	{"xsd:NOTATION","string"},
	{"xsd:NMTOKEN","string"},
	{"xsd:NMTOKENS","string"},
	
//
// Non-simple types (special base types)
//
	{"xsd:list",null},

// should be at the end of this list	
	{"xsd:anyType",null},
};


private static String[][] java_mappings = new String[][]
{
	{"string","java.lang.String"},
	{"int","java.lang.Integer"},
	{"long","java.lang.Long"},
	{"double","java.lang.Double"},
	{"boolean","java.lang.Boolean"},
	{"date","java.util.GregorianCalendar"},
	{"list","java.util.List"},
};

	public static String reformat(String str, int depth) {
		StringBuffer sb = new StringBuffer();
		
		str = str.trim();
		
		boolean afterNL = false;
		
		for (int i = 0; i < str.length(); i++) {
			char c = str.charAt(i);
			if (c == '\n') {
				afterNL = true;
				sb.append(c);
				//indent after newline
				for (int k = 0; k < depth; k++) {
					sb.append(' ');	
				}

			} else if (c == ' ' || c == '\t') {
				if (afterNL) {
					//ignore whitespace after newline
				} else {
					sb.append(c);
				}
				
			} else {
				afterNL = false;
				sb.append(c);	
			}
		}
		
		return sb.toString();	
	}

	public static String replace(String str, String match, String replace) {
		
		StringBuffer buf = new StringBuffer();
			
		int pos = 0;
		int index = 0;
			
		while (index != -1) {
			index = str.indexOf(match,pos);
			if (index != -1) {
				buf.append(str.substring(pos,index)).append(replace);
				pos = index + match.length();
			} else if (pos < str.length()) {
				buf.append(str.substring(pos));
			}
		}
	
		return buf.toString();			
	}


	public static String[] getXSDBaseTypes() {
		String[] tmp = new String[xsd_mappings.length];
		for (int i = 0; i < tmp.length; i++) {
			tmp[i] = xsd_mappings[i][0];
		}		
		return tmp;
	}

	public String getInternalJavaType(String base_ncname) {
		String xsdmapped = getInternalBaseMapping(base_ncname);
		if (xsdmapped != null) {
			//this Xsd type is mapped to another xsd type
			base_ncname = xsdmapped;
		}
		for (int i = 0; i < java_mappings.length; i++) {
			if (java_mappings[i][0].equals(base_ncname)) {
				return java_mappings[i][1];
			}
		}
		return null;
	}
	
	public String getInternalBaseMapping(String base_ncname) {
		if (ncmappings == null) {
			ncmappings = new HashMap();
			for (int i = 0; i < xsd_mappings.length; i++) {
				if (xsd_mappings[i][1] != null) {
					ncmappings.put(NamespaceTranslator.getName(xsd_mappings[i][0]),NamespaceTranslator.getName(xsd_mappings[i][1]));
				}
			}
		}
		String mapping = (String)ncmappings.get(base_ncname);
		if (mapping == null) {
			return base_ncname;
		} else {
			return mapping;
		} 
	}
	
	public String getInternalBaseMapping(NamespaceTranslator nt, String qbase) throws NamespaceException {
		
		if (qmappings == null) {
			qmappings = new HashMap();
			for (int i = 0; i < xsd_mappings.length; i++) {
				if (xsd_mappings[i][1] != null) {
					qmappings.put(nt.qualify(xsd_mappings[i][0],false),nt.qualify("xsd:"+xsd_mappings[i][1],false));
				}
			}
		}
		
		String mapping = (String)qmappings.get(qbase);
		if (mapping == null) {
			return qbase;
		} else {
			return mapping;
		} 
	}

	
	public String getSimpleTypeBase(NamespaceTranslator nt, Element simple) throws NamespaceException {

		String base = null;

		String namespace = null;
		String tag = null;
		
		ArrayList children = getAllElements(simple);
		for (int i = 0; i < children.size(); i++) {
			Element child = (Element)children.get(i);
			namespace = nt.getPackage(child,false);
			tag = NamespaceTranslator.getName(child);
			
			System.out.println("------- SUB TAG: "+tag);

			if (namespace.equals(nt.getXSDPackage())) {

				System.out.println("------- SUB TAG (NAMESPACE OK): "+tag);
				
				if (tag.equals("restriction")) {
					base = child.getAttribute("base");
					
				} else if (tag.equals("list")) {
					base = child.getTagName();	//xsd:list
					
				} else if (tag.equals("union")) {
//					base = child.getTagName();	//xsd:union
//					base = "xsd:anyType";
					
					ArrayList types = getAllElements(child);
					
					for (int k = 0; k < types.size(); k++) {
						Element subchild = (Element)types.get(k);
						String typens = nt.getPackage(subchild,false);
						String subtag = NamespaceTranslator.getName(subchild);
						
						if (typens.equals(nt.getXSDPackage())) {
							if (subtag.equals("simpleType")) {
								return getSimpleTypeBase(nt,subchild);
							}
						}
					}
				
				}	
				
			} else {
				System.out.println("SimpleType tag found without XSD namespace:");
				System.out.println("TAGNS:"+namespace);
				System.out.println("XSDNS:"+nt.getXSDPackage());
			}

			System.out.println("------- BASE SET TO "+base);
		}

		if (base == null) {
			throw new NamespaceException("simpleType base not found for "+TranslatorUtils.toJavaString(simple)+" (resolved namespace into package "+getQNameFromQName(namespace)+")");
		}
		
		return base;	
	}
	
	public static String getSimpleTypeListType(NamespaceTranslator nt, Element simple) throws NamespaceException {
		String listType = XSDTypeTranslator.XSD_TYPE_ANYTYPE;
		
		//we are a list, therefore we need to pass in a special argument to the base compiler
		ArrayList elems = Util.getAllElements(simple);
		for (int i = 0; i < elems.size(); i++) {
			Element elem = (Element)elems.get(i);
			String namespace = nt.getNamespace(elem,false);
			String tag = NamespaceTranslator.getName(elem);

			if (namespace.equals(NamespaceTranslator.NAMESPACE_XSD)) {
				if (tag.equals("list")) {
					listType = elem.getAttribute("itemType");	
				}	
			}
		}
		
		return listType;
	}
	

	public static ArrayList getAllElements(Element elem, String name) {
		NodeList list = elem.getChildNodes();
		ArrayList elems = new ArrayList();
		for (int i = 0; i < list.getLength(); i++) {
			Node node = list.item(i);
			if (node instanceof Element) {
				Element tmp = (Element)node;
				if (NamespaceTranslator.getName(tmp.getTagName()).equals(name)) {
					elems.add(node);
				}
			}	
		}	
		return elems;
	}

	public static Element getFirstElement(Element elem, String name) {
		NodeList list = elem.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			Node node = list.item(i);
			if (node instanceof Element) {
				Element tmp = (Element)node;
				if (NamespaceTranslator.getName(tmp.getTagName()).equals(name)) {
					return tmp;
				}
			}	
		}	
		return null;
	}
	
	public static ArrayList getAllElements(Element elem) {
		NodeList list = elem.getChildNodes();
		ArrayList elems = new ArrayList();
		for (int i = 0; i < list.getLength(); i++) {
			Node node = list.item(i);
			if (node instanceof Element) {
				elems.add(node);
			}	
		}	
		return elems;
	}
	
	private static int getPosition(Node elem) {
		int pos = 0;
		Node prev = elem.getPreviousSibling();
		while (prev != null) {
//			if (prev.getNodeType() != Node.TEXT_NODE
//				&& prev.getNodeType() != Node.DOCUMENT_TYPE_NODE) {
			if (prev.getNodeType() == Node.ELEMENT_NODE) {
				//we ignore all text nodes apart from original node
				pos++;
			}
			prev = prev.getPreviousSibling();
		}
		return pos;
	}
	
	private String clean(String fileref) {
		if (fileref == null) return null;
		char[] dat = fileref.toCharArray();
		for (int i = 0; i < dat.length; i++) {
			if (dat[i] >=32 && dat[i] <= 126) {
				//OK
			} else {
				dat[i] = '_';
			}
		}
		return new String(dat);
	}

	public String getBpelLineNumberString(Node n) {
//		return getLineNumberString(n,bpel_source,path_hashmap);
//		return "(line "+getLineNumber(n,bpel_source,line_hashmap,path_hashmap)+")";
		return "(file: "+clean(n.getFileRef())+", line: "+n.getStartLine()+")";
	}
	public int getBpelLineNumber(Node n) {
		return getLineNumber(n,bpel_source,line_hashmap,path_hashmap);
	}
	public static String getLineNumberString(Node n, String sourceXml) {
		return "(line "+getLineNumber(n,sourceXml)+")";
	}
	public static int getLineNumber(Node n, String sourceXml) {
		return getLineNumber(n,sourceXml,null,null);
	}
	private static int getLineNumber(Node n, String sourceXml, HashMap line_hashmap, HashMap path_hashmap) {
		
		return n.getStartLine();
		
		//TODO
//		return -1;
	}
	/*
	private static int getLineNumber(Node n, String sourceXml, HashMap line_hashmap, HashMap path_hashmap) {
		try {
			
			if (line_hashmap != null) {
				return ((Integer)line_hashmap.get(n)).intValue();
			}
			
			Node origNode = n;
			Transformer tf = TransformerFactory.newInstance().newTransformer();
//			tf.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,"yes");
			tf.setOutputProperty(OutputKeys.INDENT,"no");
//			tf.setOutputProperty(OutputKeys.VERSION,"1.0");

			if (sourceXml == null) {
				System.out.println("Source not available for XML node line detection - generating instead");

				Document d = null;
				while (n.getParentNode() != null) {
					n = n.getParentNode();
					if (n instanceof Document) {
						d = (Document)n;
						break;
					}
				}
				
				ByteArrayOutputStream bout = new ByteArrayOutputStream();
	
				DOMSource ds = new DOMSource(n);
				StreamResult res = new StreamResult(bout);
				tf.transform(ds,res);
				
				sourceXml = new String(bout.toByteArray());
			}
			
			System.out.println(sourceXml);

			LineTracker linetracker = new LineTracker(origNode,path_hashmap);
//			SAXSource source = new SAXSource(new InputSource(new ByteArrayInputStream(bout.toByteArray())));
			SAXSource source = new SAXSource(new InputSource(new StringReader(sourceXml)));
			SAXResult result = new SAXResult(linetracker);
	
			tf.transform(source,result);
			
			return linetracker.getLine();
		} catch (NullPointerException e) {
			System.out.println("Could not find entry for ("+n.getClass().getName()+") "+n);
			return -1;
		} catch (Exception e) {
			e.printStackTrace();
			return -1;
		}
	}
	private static class LineTracker implements ContentHandler {
		int line = -1;
		int col = -1;
		Locator loc;
		
		public int getLine() {
			return line;
		}
		
		Node n;
		HashMap line_hashmap;
		HashMap path_hashmap;
		int[] path;
		int[] curr;
		
		public LineTracker(Node n, HashMap path_hashmap) {
			this.n = n;
			
			if (path_hashmap != null) {
				path = (int[])path_hashmap.get(n);
			} else {
				path = getStackTrace(n);
			}
			
			curr = new int[path.length];
			Arrays.fill(curr,-1);
		}
		public LineTracker(HashMap line_hashmap, HashMap path_hashmap) {
			this.line_hashmap = line_hashmap;
			this.path_hashmap = path_hashmap;

			curr = new int[10000];
			Arrays.fill(curr,-1);
		}
		
		int depth = 0;
		
		public void endDocument() throws SAXException {
		}
		public void startDocument() throws SAXException {
		}
		public void characters(char[] arg0, int arg1, int arg2) throws SAXException {}
		public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {}
		public void endPrefixMapping(String arg0) throws SAXException {}
		public void skippedEntity(String arg0) throws SAXException {
		}
		public void setDocumentLocator(Locator arg0) {
			this.loc = arg0;
		}
		public void processingInstruction(String arg0, String arg1) throws SAXException {}
		public void startPrefixMapping(String arg0, String arg1) throws SAXException {}
		public void endElement(String arg0, String arg1, String arg2) throws SAXException {
			if (depth < curr.length) curr[depth] = -1;
			depth--;
		}
		public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
try {
			if (depth < curr.length) curr[depth]++;

//			System.out.print(arg1+" - ");
//			for(int i = 0; i < curr.length; i++) {
//				if (i == depth) {
//					System.out.print("["+curr[i]+"], ");
//				} else {
//					System.out.print(curr[i]+", ");
//				}
//			}
//			System.out.println("");

			if (line_hashmap != null) {
				int[] tmp = new int[depth];
				System.arraycopy(curr,0,tmp,0,depth);
				
				Object key = path_hashmap.get(stackTraceToString(tmp));
				if (key != null) {
					System.out.println("ENTERING LINE NUMBER "+loc.getLineNumber()+" - "+arg1);
					line_hashmap.put(key,new Integer(loc.getLineNumber()));
				}
			} else {
			
				if (Arrays.equals(path,curr)) {
					if (line == -1) {
						line = loc.getLineNumber();
						col = loc.getColumnNumber();
	//					System.out.println("FOUND LINE NUMBER: "+arg1+" "+line+" "+col+" -- "+n);
					}
				}
			}
						
			depth++;
} catch (Throwable t) {
t.printStackTrace();
System.exit(0);
}
		}
	}
	*/
	public int[] getBpelStackTrace(Node elem) {
		int[] stack = (int[])path_hashmap.get(elem);
		if (stack == null) stack = getStackTrace(elem);
		return stack;
	}
	public String getBpelStackTraceString(Node elem) {
		return stackTraceToString(getBpelStackTrace(elem));
	}
	public static int[] getStackTrace(Node elem) {
		ArrayList list = new ArrayList();
		
		Node parent = elem;
		while (parent != null) {
			list.add(new Integer(getPosition(parent)));
			parent = parent.getParentNode();
			if (parent != null) {
				if (parent.getNodeType() == Node.DOCUMENT_NODE) {
					parent = null;
				}
			}
		}
		Collections.reverse(list);
		
		int[] ret = new int[list.size()];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = ((Integer)list.get(i)).intValue();
		}
		return ret;
	}
	public static String getStackTraceString(Node elem) {
		if (elem == null) return "(n/a)";
		
		int[] trace = getStackTrace(elem);
		return stackTraceToString(trace);
	}
	public static int[] getStackTraceFromString(String tracestr) throws NoSuchElementException, NumberFormatException {
		StringTokenizer tok = new StringTokenizer(tracestr,"(, \t\n)");
		int[] trace = new int[tok.countTokens()];
		
		for (int i = 0; i < trace.length; i++) {
			String token = tok.nextToken();
			trace[i] = Integer.parseInt(token.trim());
		}
		
		return trace;
	}
	public static String stackTraceToString(int[] trace) {
		StringBuffer sb = new StringBuffer();
		sb.append("(");
		for (int i = 0; i < trace.length; i++) {
			sb.append(trace[i]);
			if (i < trace.length-1) {
				sb.append(",");
			}
		}
		sb.append(")");
		return sb.toString();
	}

	public static String getTextDirectlyUnder(Element elem) {
		StringBuffer sb = new StringBuffer();
		NodeList list = elem.getChildNodes();
		for (int i = 0; i < list.getLength(); i++) {
			Node n = (Node)list.item(i);
			if (n.getNodeType() == Node.TEXT_NODE) {
				sb.append(n.getNodeValue());	
			}	
		}
		return sb.toString();
	}

	public static String[] split(String str) {
		ArrayList strings = new ArrayList();
		StringBuffer sb = new StringBuffer();
		
		for (int i = 0; i <	str.length(); i++) {
			char c = str.charAt(i);
			if (c == ' '
				|| c == '\t') {
					
				if (sb.length() > 0) {
					strings.add(sb.toString());
					sb.setLength(0);
				}
				
			} else {
				sb.append(c);	
			}	
		}
		
		if (sb.length() > 0) {
			strings.add(sb.toString());
			sb.setLength(0);
		}

		String[] ret = new String[strings.size()];
		for (int i = 0; i < ret.length; i++) {
			ret[i] = (String)strings.get(i);	
		}
		return ret;
	}
	
}