/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.compiler.wsdlmap;

import java.util.HashMap;

/**
 * 
 * @author amiguel
 *
 * A class to represent a Port Type, used in the translation 
 * of BPEL source files into engine Programs
 */
public class WSDLPortType {
	public String name;
	public HashMap name_to_operation = new HashMap(); 
	
	public String getName() {
		return name;
	}
	public WSDLOperation getOperation(String opname) {
		return (WSDLOperation)name_to_operation.get(opname);
	}
}
