/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.mainengine;

import java.util.ArrayList;

import org.eclipse.stp.b2j.core.jengine.internal.compiler.Util;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;
import org.eclipse.stp.b2j.core.misc.internal.HexData;
import org.eclipse.stp.b2j.core.misc.internal.XMLUtil;
import org.eclipse.stp.b2j.core.publicapi.JARDependency;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Document;
import org.eclipse.stp.b2j.core.xml.internal.w3c.Element;

public class SoapDaemonUtils {
	
	public static final String TAG_SESSION_ADDRESS = "SessionAddress";

	public static final String TAG_VERSIONS = "Versions";
	public static final String TAG_VERSION = "Version";

	public static final String TAG_DESCRIPTION = "Description";
	
	public static final String TAG_DEPENDENCIES = "Dependencies";
	public static final String TAG_JAR_DEPENDENCY = "JARDependency";

	public static final String TAG_ID = "ID";
	
	public static final String TAG_JAR = "JAR";

	public static final String TAG_SUPPORTED_VERSION = "SupportedVersion";

	public static final String TAG_PASSWORD = "Password";

	public static final String TAG_ERROR = "Error";

	public static final String TAG_ENGINES = "EngineInstances";
	public static final String TAG_ENGINE = "EngineInstance";
	
	public static Element getDocumentEncodedMessageBody(String response) throws Exception {
		Document message_doc = XMLUtil.documentFromString(response);

		Element env_elem = message_doc.getDocumentElement();
		Element body_elem = Util.getFirstElement(env_elem,"Body");
		
		return body_elem;
	}
	public static Element getResponseBody(String response) throws Exception {
		Document message_doc = XMLUtil.documentFromString("<Body>"+response+"</Body>");

		Element env_elem = message_doc.getDocumentElement();
//		Element body_elem = Util.getFirstElement(env_elem,"Body");
		
		return env_elem;
	}
	
	
	public static String elementToDescription(Element description) throws Exception {
		return Util.getTextDirectlyUnder(description);
	}
	public static String descriptionToElement(String description) throws Exception {
		return "<"+TAG_DESCRIPTION+">"+description+"</"+TAG_DESCRIPTION+">";
	}
	
	public static boolean elementToSupported(Element element) throws Exception {
		return Util.getTextDirectlyUnder(element).equals("true");
	}

	public static String engineToElement(long id, String description) throws Exception {
		return "<EngineInstance><id>"+id+"</id><description>"+description+"</description></EngineInstance>";
	}
	
	public static String supportedToElement(boolean supported) throws Exception {
		return "<SupportedVersion>"+supported+"</SupportedVersion>";
	}

	public static int elementToId(Element element) throws Exception {
		return Integer.parseInt(Util.getTextDirectlyUnder(element));
	}
	
	public static String idToElement(int id) throws Exception {
		return "<ID>"+id+"</ID>";
	}

	public static byte[] elementToJar(Element element) throws Exception {
		return HexData.hexStringToByteArray(Util.getTextDirectlyUnder(element));
	}
	
	public static String jarToElement(byte[] dat) throws Exception {
		return "<JAR>"+HexData.byteArrayToHexString(dat)+"</JAR>";
	}
	
	public static String sessionAddressToElement(SessionAddress address) throws Exception {
		return "<SessionAddress>"+HexData.stringToHexString(SessionAddress.toString(address))+"</SessionAddress>";
	}
	
	public static SessionAddress elementToSessionAddress(Element element) throws Exception {
		return SessionAddress.fromString(HexData.hexStringToString(Util.getTextDirectlyUnder(element)));
	}

	public static Message elementToVersion(Element element) throws Exception {
		ArrayList part_Version = Util.getAllElements(element,TAG_VERSION);
		
		Message versions = new Message();
		for (int i = 0; i < part_Version.size(); i++) {
			String text_Version = Util.getTextDirectlyUnder((Element)part_Version.get(i));
			versions.append( Integer.parseInt(text_Version) );
		}
		return versions;
	}
	
	public static String versionToElement(Message version) throws Exception {
		StringBuffer tmp = new StringBuffer();
		
		tmp.append("<Versions>");
		for (int i = 0; i < version.length(); i++) {
			tmp.append("<Version>");
			tmp.append(version.get(i));
			tmp.append("</Version>");
		}
		tmp.append("</Versions>");

		return tmp.toString();
	}
	
	public static String elementToError(Element element) throws Exception {
//		return HexData.hexStringToString(Util.getTextDirectlyUnder(element));
		return Util.getTextDirectlyUnder(element);
	}
	
	public static String errorToElement(String password) throws Exception {
		StringBuffer tmp = new StringBuffer();
		
		tmp.append("<Error>");
//		tmp.append(HexData.stringToHexString(password));
		tmp.append(password);
		tmp.append("</Error>");
		
		return tmp.toString();
	}

	public static String elementToPassword(Element element) throws Exception {
//		return HexData.hexStringToString(Util.getTextDirectlyUnder(element));
		return Util.getTextDirectlyUnder(element);
	}
	
	public static String passwordToElement(String password) throws Exception {
		StringBuffer tmp = new StringBuffer();
		
		tmp.append("<Password>");
//		tmp.append(HexData.stringToHexString(password));
		tmp.append(password);
		tmp.append("</Password>");
		
		return tmp.toString();
	}
	
	public static JARDependency[] elementToJARDependency(Element element) throws Exception {
		ArrayList part_JARDependency = Util.getAllElements(element,TAG_JAR_DEPENDENCY);
		
		JARDependency[] deps = new JARDependency[part_JARDependency.size()];
		for (int i = 0; i < part_JARDependency.size(); i++) {
			String text_JARDependency = Util.getTextDirectlyUnder((Element)part_JARDependency.get(i));
			deps[i] = JARDependency.fromHex(text_JARDependency);
		}
		
		return deps;
	}
	
	public static String jarDependencyToElement(JARDependency[] deps) throws Exception {
		StringBuffer tmp = new StringBuffer();
		tmp.append("<Dependencies>");
		for (int i = 0; i < deps.length; i++) {
			tmp.append("<JARDependency>");
			tmp.append(JARDependency.toHex(deps[i]));
			tmp.append("</JARDependency>");
		}
		tmp.append("</Dependencies>");
		return tmp.toString();
	}
}