/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.jengine.internal.message;


import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

/**
 * @author amiguel
 * 
 * A class to write message to an output stream
 * Using a BufferedOutputStream is recommended for this class
 */
public class MessageWriter implements MessageConstants {

	OutputStream out;

	/**
	 * Construct a new MessageWriter
	 * @param out the output stream to write to
	 */
	public MessageWriter(OutputStream out) {
		this.out = new BufferedOutputStream(out);
	}//end class

	/**
	 * Write a message
	 * @param m the message to write
	 */	
	public void write(Message m) throws IOException {
		MessageUtils.writeMessage(out,m);
	}//end method

/*
	byte[] bi = new byte[4];
	byte[] bl = new byte[8];
	private void writeInt(OutputStream o, int i) throws IOException {
		bi[0] = (byte) (i>>24);
		bi[1] = (byte) (i>>16);
		bi[2] = (byte) (i>>8);
		bi[3] = (byte) (i);
		o.write(bi);
	}//end method
	private void writeLong(OutputStream o, long i) throws IOException {
		bl[0] = (byte) (i>>56);
		bl[1] = (byte) (i>>48);
		bl[2] = (byte) (i>>40);
		bl[3] = (byte) (i>>32);
		bl[4] = (byte) (i>>24);
		bl[5] = (byte) (i>>16);
		bl[6] = (byte) (i>>8);
		bl[7] = (byte) (i);
		o.write(bl);
	}//end method
*/
}//end class
