/**********************************************************************
 * Copyright (c) 2005 Scapa Technologies Limited and others
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * Scapa Technologies Limited - Initial API and implementation
 **********************************************************************/

package org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport;

import java.io.InputStream;
import java.io.OutputStream;

import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

/**
 * 
 * @author amiguel
 *
 * An abstraction of a session transport to allow actual transports to be
 * swapped around underneath the Session implementation
 */
public interface SessionTransport {
	
	/**
	 * Set the session address for this transport
	 * @param address
	 */
	public void setSessionAddress(SessionAddress address);
	
	/**
	 * Does this transport natively provide encryption?
	 * @return
	 */
	public boolean providesEncryption();

	/**
	 * Does this transport natively provide authentication?
	 * @return
	 */
	public boolean providesAuthentication();
	
	/**
	 * What is the current strength of this transports encryption?
	 * @return
	 */
	public int getEncryptionStrengthBits();

	/**
	 * Set the strength of this transports encryption
	 * @return
	 */
	public void setRequiredEncryptionStrengthBits(int bits);
	
	/**
	 * Get the actual SessionAddress required to recreate this link
	 * @return
	 */
	public SessionAddress getActualAddress();
	
	/**
	 * Start/Restart this transport
	 * @throws Exception
	 */
	public void tryReconnect() throws Exception;

	/**
	 * Start/Restart this transport
	 * @param timeout_ms_hint a hint to say how long this transport should wait before timing out
	 * @throws Exception
	 */
	public void tryReconnect(long timeout_ms_hint) throws Exception;
	
	/**
	 * Get the input stream for this transport (can be replaced during tryReconnect)
	 * @return
	 */
	public InputStream getInputStream();
	
	/**
	 * Get the output stream for this transport (can be replaced during tryReconnect)
	 * @return
	 */
	public OutputStream getOutputStream();

	/**
	 * Close this transport link
	 *
	 */
	public void close();
	
	/**
	 * Return whether this transport is alive (connected and working) or not
	 * @return true if this transport is alive (connected and working) or not
	 */
	public boolean isAlive();
	
}