/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.controls;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.soas.internal.deploy.ui.viewers.DropListViewer;


/**
 * @author rcernich
 * 
 * Created on Oct 13, 2004
 */
public class EMFDropListViewer extends EMFControl {
	
	private DropListViewer mViewer;

	/**
	 * @param control
	 * @param domain
	 * @param feature
	 */
	public EMFDropListViewer(DropListViewer viewer,
									EStructuralFeature feature) {
		super(viewer.getControl(), feature);
		mViewer = viewer;
	}

	public DropListViewer getDropListViewer() {
		return (DropListViewer) mViewer;
	}

	public Object getSelection() {
		return getDropListViewer().getSelection();
	}

	public void setSelection(Object object) {
		if (object == null) {
			// Should be reasonable
			getDropListViewer().setSelection(StructuredSelection.EMPTY);
		}
		else {
			getDropListViewer().setSelection(new StructuredSelection(object));
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.controls.EMFControl#getControlValue()
	 */
	public Object getControlValue() {
		return getSelection();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.controls.EMFControl#setControlValue(java.lang.Object)
	 */
	public void setControlValue(Object value) {
		setSelection(value);
	}

}