/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.emf.controls;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Text;

/**
 * @author rcernich
 * 
 * Created on Oct 13, 2004
 */
public class EMFTextControl extends EMFControl {

	/**
	 * @param control
	 * @param domain
	 * @param feature
	 */
	public EMFTextControl(Text control, EStructuralFeature feature) {
		super(control, feature);
	}

	public Text getTextControl() {
		return (Text) getControl();
	}

	public String getText() {
		return getTextControl().getText();
	}

	public void setText(String text) {
		if (text == null) {
			// Should be reasonable
			text = new String();
		}
		getTextControl().setText(text);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.controls.EMFControl#getControlValue()
	 */
	public Object getControlValue() {
		return getText();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.controls.EMFControl#setControlValue(java.lang.Object)
	 */
	public void setControlValue(Object value) {
		String text;
		if (value instanceof String) {
			text = (String) value;
		}
		else {
			if (value == null) {
				text = null;
			}
			else {
				// Hopefully this works for all object types. (Should work for
				// ints, etc.)
				text = value.toString();
			}
		}
		setText(text);
	}

}