package org.eclipse.stp.sc.cxf.wizard;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.cxf.generators.CxfJava2wsGenerator;
import org.eclipse.stp.sc.cxf.natures.CxfSimpleFrontendNature;
import org.eclipse.stp.sc.cxf.wizard.simplefe.CxfJava2wsParameterPageContentsSimple;
import org.eclipse.stp.sc.jaxws.wizards.AdditionalWizardPage;

public class Java2wsWizard  extends Wizard{
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(Java2wsWizard.class);
	
	public static final String PAGE_NAME = "Java2ws Generation";
	
	private AdditionalWizardPage java2wsPage;
	private IProject project;
	
	public boolean performFinish(){
		java2wsPage.performFinish(project);
		CxfJava2wsGenerator generator = CxfJava2wsGenerator.getInstance();
		try{
			project.build(IncrementalProjectBuilder.INCREMENTAL_BUILD, null);
			generator.run(project);
		}catch(Exception ex){
			LOG.error("error during java2ws generation", ex);
		}
		return true;
	}
	
	public void addPages(){
		try{
			CxfJava2wsParameterPageContents pageContents;
			if(project.hasNature(CxfSimpleFrontendNature.NATURE_ID)){
				pageContents = new CxfJava2wsParameterPageContentsSimple();
			}else{
				pageContents = new CxfJava2wsParameterPageContents();
			}
			pageContents.setProject(project);
			java2wsPage = new AdditionalWizardPage(PAGE_NAME, pageContents);
			java2wsPage.setPageContents(pageContents);
			addPage(java2wsPage);
		}catch(Exception ex){
			LOG.error("error while setting up java2ws generator parameter wizard page", ex);
		}
	}
	
	public void setProject(IProject project){
		this.project = project;
	}
}
