/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

/**
 * @author rcernich
 * 
 * Created on Mar 25, 2004
 */
public class ProjectsFilter extends ViewerFilter {

	private IProject mSourceProject;
	private List mAvailableProjects;

	private Comparator mProjectComparator = new Comparator() {

		public int compare(Object o1, Object o2) {
			return ((IProject) o1).getFullPath().toString().compareTo(
					((IProject) o2).getFullPath().toString());
		}

		public boolean equals(Object obj) {
			return compare(this, obj) == 0;
		}
	};

	public ProjectsFilter(IProject sourceProject) {
		super();
		mSourceProject = sourceProject;
		updateAvailableProjects();
	}

	public boolean setSourceProject(IProject sourceProject) {
		boolean doUpdate;
		if (sourceProject == null) {
			if (mSourceProject == null) {
				doUpdate = false;
			}
			else {
				doUpdate = true;
			}
		}
		else if (sourceProject.equals(mSourceProject)) {
			doUpdate = false;
		}
		else {
			doUpdate = true;
		}

		if (doUpdate) {
			mSourceProject = sourceProject;
			updateAvailableProjects();
		}
		return doUpdate;
	}

	private void updateAvailableProjects() {
		if (mSourceProject == null) {
			mAvailableProjects = new Vector(Arrays.asList(ResourcesPlugin
					.getWorkspace().getRoot().getProjects()));
		}
		else {
			IProject[] projects;
			try {
				projects = mSourceProject.getReferencedProjects();
			}
			catch (CoreException e) {
				projects = new IProject[0];
			}
			mAvailableProjects = new Vector(projects.length + 1);
			mAvailableProjects.add(mSourceProject);
			mAvailableProjects.addAll(Arrays.asList(projects));
		}
		Collections.sort(mAvailableProjects, mProjectComparator);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.viewers.ViewerFilter#select(org.eclipse.jface.viewers.Viewer,
	 *      java.lang.Object, java.lang.Object)
	 */
	public boolean select(Viewer viewer, Object parentElement, Object element) {
		boolean retVal;
		if (element instanceof IProject) {
			retVal = Collections.binarySearch(mAvailableProjects, element,
					mProjectComparator) >= 0;
		}
		else {
			retVal = true;
		}
		return retVal;
	}

}
