/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;



/**
 * This interface is used for accessing functionality and information provided
 * by a configurablePackage extension point implementation.
 * 
 * @author rcernich
 *
 * Created on Oct 23, 2004
 */
public interface IConfigurablePackageExtension extends IPackageExtension {
	
	/**
	 * Returns a configuration manager for this package extension.  The
	 * configuration manager is used by the framework for persisting
	 * serialization/deserialization of configuration information and for
	 * retrieving UI components that can be used to modify configuration
	 * information in the deployment editor.
	 * 
	 * @return the configuration manager for this extension.
	 */
	IPackageConfigurationManager getPackageConfigurationManager();

}
