/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core;

import org.eclipse.core.resources.IFile;


/**
 * Base interface for package objects (logical, configured and physical).
 * Provides access to common information defined through both extension points.
 * 
 * @author rcernich
 *
 * Created on Apr 7, 2004
 */
public interface IPackage {

	/**
	 * Initializes this package object with the source extension and the file
	 * representing the package or package definition.
	 * 
	 * @param extension the extension used to create this object.
	 * @param pkg the file representing the package or package definition.
	 */
	void init(IPackageExtension extension, IFile pkg);

	/**
	 * Returns the name of this package.
	 * 
	 * @return the name of this package.
	 */
	String getName();

	/**
	 * Returns a description associated with this package.
	 * 
	 * @return a description for the package.
	 */
	String getDescription();
	
	/**
	 * Returns the file representing this package on disk.
	 * 
	 * @return the file representing this package.
	 */
	IFile getFile();

	/**
	 * Returns the IPackageExtension object used to create this package object.
	 * 
	 * @return the packaging extension managing this package type.
	 */
	IPackageExtension getExtension();

}
