/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.deploy.core.adapters;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.DeploymentExtensionManager;
import org.eclipse.stp.soas.deploy.core.IConfigurablePackage;
import org.eclipse.stp.soas.deploy.core.IDeployTarget;
import org.eclipse.stp.soas.deploy.core.IServiceDescriptor;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.IPhysicalPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.wst.server.core.IServer;

/**
 * @author rcernich
 * 
 * Created on Jul 16, 2004
 */
public class DeployPackageDeployAPIAdapter extends AdapterImpl implements
		IDeployAPIAdapter {

	public DeployPackageDeployAPIAdapter() {
		super();
	}

	public boolean isAdapterForType(Object type) {
		return type == IDeployAPIAdapter.class;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asDeployTarget()
	 */
	public IDeployTarget asDeployTarget() {
		return null;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asLogicalPackage()
	 */
	public IServiceDescriptor asLogicalPackage() {
		IServiceDescriptor ilp;
		IFile file = getFile();
		if (file == null) {
			ilp = null;
		}
		else {
			ilp = DeploymentExtensionManager.getInstance().getLogicalPackage(
					file);
		}
		return ilp;
	}

	public IConfigurablePackage asConfigurablePackage() {
		IConfigurablePackage icp;
		IFile file = getFile();
		if (file == null) {
			icp = null;
		}
		else {
			icp = DeploymentExtensionManager.getInstance()
					.getConfigurablePackage(file);
		}
		return icp;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asPackage()
	 */
	public IPackage asPackage() {
		IPackage ip;
		IFile file = getFile();
		if (file == null) {
			ip = null;
		}
		else {
			ip = DeploymentExtensionManager.getInstance().getPackage(file);
		}
		return ip;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asPhysicalPackage()
	 */
	public IPhysicalPackage asPhysicalPackage() {
		IPhysicalPackage ipp;
		IFile file = getFile();
		if (file == null) {
			ipp = null;
		}
		else {
			ipp = DeploymentExtensionManager.getInstance().getPhysicalPackage(
					file);
		}
		return ipp;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.deploy.core.adapters.IDeployAPIAdapter#asConnectionProfile()
	 */
	public IServer asServer() {
		return null;
	}

	private IFile getFile() {
		try {
			IFile retVal;
			DeployPackage dp = (DeployPackage) getTarget();
			if (dp.eResource() == null) {
				return null;
			}
			String path = dp.getPackageFile();
			URL url = FileLocator.toFileURL(new URL(dp.eResource().getURI()
					.toString()));
			IFile deployFile = DeployCorePlugin.getWorkspace().getRoot()
					.getFileForLocation(new Path(url.getPath()));
			IProject project = deployFile.getProject();
			
			IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
			
			retVal = project.getFile(path);
			for (Iterator it = Arrays.asList(
					project.getReferencedProjects()).iterator(); !retVal
					.exists()
					&& it.hasNext();) {
				project = (IProject) it.next();
				retVal = project.getFile(path);
			}
				
			if (!retVal.exists()) {
				retVal = root.getFile(new Path(path));
			}
			
			if (retVal.exists()) {
				return retVal;
			}
		}

		catch (MalformedURLException e) {
		}
		catch (IOException e) {
		} catch (CoreException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}

}