/*******************************************************************************
 * Copyright (c) 2004-2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: Sybase, Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.stp.soas.internal.deploy.ui.editors;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.stp.soas.deploy.core.IHelpConstants;
import org.eclipse.stp.soas.deploy.core.IPackage;
import org.eclipse.stp.soas.deploy.core.DeployCorePlugin;
import org.eclipse.stp.soas.deploy.core.Utilities;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployConfiguration;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployPackage;
import org.eclipse.stp.soas.deploy.models.deployfile.DeployServer;
import org.eclipse.stp.soas.deploy.models.deployfile.Root;
import org.eclipse.stp.soas.internal.deploy.emf.AdapterFactoryContentProvider;
import org.eclipse.stp.soas.internal.deploy.ui.editors.EnhancedFormEditor;
import org.eclipse.stp.soas.internal.deploy.ui.help.HelpUtilities;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IPartSelectionListener;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.model.WorkbenchLabelProvider;

/**
 * @author rcernich
 * 
 * Created on Jan 21, 2004
 */
public class PackagesSection extends DeployEditorSectionPart implements
		IPartSelectionListener {

	public static final String SECTION_TITLE = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECTITLE.Packages"); //$NON-NLS-1$
	public static final String SECTION_DESC = DeployCorePlugin
			.getDefault().getResourceString(
					"DeployDefinitionEditor.SECDESC.Packages"); //$NON-NLS-1$

	private TableViewer mPackages;
	private boolean mProcessingSelectionChanged = false;

	/**
	 * @param parent
	 * @param toolkit
	 * @param style
	 */
	public PackagesSection(Composite parent, FormToolkit toolkit, int style) {
		super(parent, toolkit, style);
		getSection().setText(SECTION_TITLE);
		getSection().setDescription(SECTION_DESC);
	}

	public void createClient(FormToolkit toolkit) {
		Composite container = toolkit.createComposite(getSection());
		GridLayout layout = EnhancedFormEditor.newSectionGridLayout();
		layout.numColumns = 1;
		container.setLayout(layout);

		Table table = toolkit.createTable(container, SWT.FULL_SELECTION
				| SWT.H_SCROLL | SWT.V_SCROLL);
		mPackages = new TableViewer(table);
		GridData gd = new GridData(GridData.FILL_BOTH);
		gd.heightHint = table.getItemHeight() * 5;
		mPackages.getControl().setLayoutData(gd);
		mPackages.setContentProvider(new AdapterFactoryContentProvider(
				Utilities.getItemAdapterFactory()));
		mPackages.setLabelProvider(new PackagesLabelProvider(Utilities
				.getItemAdapterFactory()));
		mPackages.addFilter(new ViewerFilter() {

			public boolean select(Viewer viewer, Object parentElement,
					Object element) {
				return element instanceof DeployPackage;
			}
		});
		mPackages.addSelectionChangedListener(new ISelectionChangedListener() {

			public void selectionChanged(SelectionChangedEvent event) {
				mProcessingSelectionChanged = true;
				try {
					fireSelectionChanged(event.getSelection());
				}
				finally {
					mProcessingSelectionChanged = false;
				}
			}
		});

		getSection().setClient(container);

		toolkit.paintBordersFor(container);
	}

	protected void helpActivated(HyperlinkEvent event) {
		HelpUtilities
				.displayHelp(IHelpConstants.CONTEXT_ID_OVERVIEW_PAGE_PACKAGES_SECTION);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.forms.IPartSelectionListener#selectionChanged(org.eclipse.ui.forms.IFormPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void selectionChanged(IFormPart part, ISelection selection) {
		if (mProcessingSelectionChanged) {
			return;
		}
		if (!selection.isEmpty()) {
			Object obj = ((IStructuredSelection) selection).getFirstElement();
			if (obj instanceof DeployServer) {
				Set packages = new HashSet();
				for (Iterator it = ((DeployServer) obj)
						.getTargetingConfiguration().iterator(); it.hasNext();) {
					packages.add(((DeployConfiguration) it.next())
							.getSourcePackage());
				}
				mPackages.setSelection(new StructuredSelection(packages
						.toArray()));
			}
		}
	}

	/* (non-Javadoc)
	 * @see org.eclipse.stp.soas.internal.deploy.emf.editors.EMFSectionPart#setModelRoot(org.eclipse.emf.ecore.EObject)
	 */
	protected void setModelRoot(EObject modelRoot) {
		if (!(modelRoot instanceof Root)) {
			throw new IllegalArgumentException(
					"modelRoot must be of type " + Root.class); //$NON-NLS-1$
		}
		mPackages.setInput((Root) modelRoot);
	}

	private static class PackagesLabelProvider extends
			AdapterFactoryLabelProvider {

		private ILabelProvider mWorkbenchLabelProvider = new WorkbenchLabelProvider();

		/**
		 * @param adapterFactory
		 */
		public PackagesLabelProvider(AdapterFactory adapterFactory) {
			super(adapterFactory);
		}

		public Image getColumnImage(Object object, int columnIndex) {
			return getImage(object);
		}

		public String getColumnText(Object object, int columnIndex) {
			return getText(object);
		}

		public Image getImage(Object element) {
			Image image = null;

			// make sure we get an adapter on this guy
			adapterFactory.adapt(element, IItemLabelProvider.class);
			if (element instanceof DeployPackage) {
				IPackage ip = Utilities
						.adaptToIPackage((DeployPackage) element);
				if (ip == null) {
					image = super.getImage(element);
				}
				else {
					image = mWorkbenchLabelProvider.getImage(ip.getFile());
				}
			}
			else {
				image = super.getImage(element);
			}
			return image;
		}

		public String getText(Object element) {
			String text;

			// make sure we get an adapter on this guy
			adapterFactory.adapt(element, IItemLabelProvider.class);
			if (element instanceof DeployPackage) {
				IPackage ip = Utilities
						.adaptToIPackage((DeployPackage) element);
				if (ip == null) {
					text = super.getText(element);
				}
				else {
					text = ip.getFile().getFullPath().toString();
				}
			}
			else {
				text = super.getText(element);
			}
			return text;
		}

		public void dispose() {
			mWorkbenchLabelProvider.dispose();
			super.dispose();
		}
	}

}