/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.common.internal.viewers;


import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeComposite;



/**
 * the runtime composite. which will list all stp related runtime instance installed in the system
 * @author jma
 *
 */
public class StpRuntimeComposite extends RuntimeComposite {
	
	
	public StpRuntimeComposite(Composite parent, int style, SelectionListener listener2, 
			String[] moduleTypes) {
		super(parent, style, listener2);
		//use filter content provider to only show stp related runtime
		FilterRuntimeContentProvider filterProvider = new FilterRuntimeContentProvider();
		//filterProvider.setModuleTypes(new String[] {RuntimeCore.JAXWS_MODULE_TYPE});
		filterProvider.setModuleTypes(moduleTypes);
		
		tableViewer.setContentProvider(filterProvider);
		//show the tech (moduleType) column
		TableColumn col = new TableColumn(table, SWT.NONE);
		col.setText("Technologies");
		ILabelProvider labelProvider = new StpRuntimeTableLabelProvider();
		tableViewer.setLabelProvider(labelProvider);
		
		//repack
		if (table.getItemCount() > 0) {
			TableColumn[] columns = table.getColumns();
			for (int i=0; i < columns.length; i++)
				columns[i].pack();
			table.pack();
		}
		
		
	}
	
	
	public IRuntime selectRuntimeByIndex(int index) {
		try {
			table.setSelection(index);
			IRuntime runtime = (IRuntime)tableViewer.getElementAt(index);
			return runtime;
//		    UIUtils.selectWidget(table, index);
		    
		} catch (Throwable th) {
			th.printStackTrace();
			return null;
		}
 
	}
	
	public int getRuntimeCount() {
		return table.getItemCount();
	}

	public interface SelectionListener extends RuntimeSelectionListener{
		public void runtimeSelected(IRuntime runtime);
	}
	

}
