/*******************************************************************************
* Copyright (c) 2007 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.sca.java.utils;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.stp.sc.common.internal.model.RuntimeCore;
import org.eclipse.wst.server.core.IRuntime;

/**
 * test utils for sca, which used to setup the runtime for test
 * @author jma
 *
 */
public class TestUtilities {
	
	static String TEST_TUSCANY_RUNTIME_ID = "test_sca_runtime";
    static String TEST_TUSCANY_RUNTIME_TYPE = "org.eclipse.stp.soas.deploy.runtime.tuscanyjava.099";
    
    /**
     * add a cxf runtime for test
     * @param project
     */
    public static  void setupTestRuntimeInfo(IProject project) {
    	String runtimeId = createTestRuntime();
    	RuntimeCore.setRuntimeID(project, runtimeId);
		RuntimeCore.setRuntimeType(project, TEST_TUSCANY_RUNTIME_TYPE);
    }
    
    public static String createTestRuntime() {
    	try {
    	IRuntime runtime = RuntimeCore.getRuntime(TEST_TUSCANY_RUNTIME_ID);
    	String runtimeId = null;
    	if (runtime == null) {
    		String kitLocation = System.getProperty(RuntimeCore.SCA_KIT_TESTPROPERTY);
            IPath kitPath = new Path(kitLocation);
            
    		runtimeId = RuntimeCore.creatRuntime(TEST_TUSCANY_RUNTIME_TYPE, TEST_TUSCANY_RUNTIME_ID, kitPath);
    	} else {
    		runtimeId = runtime.getId();
    	}
    	return runtimeId;
    	} catch (Throwable th) {
    		th.printStackTrace();
    	}
    	return null;
    }

}
