/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards;

import java.io.File;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.stp.sc.jaxws.ScJaxWsResources;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IPageContentsChangeListener;
import org.eclipse.stp.sc.jaxws.runtimeprovider.IStartingPointPageContents;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractStartingPointPageContents implements IStartingPointPageContents {

	protected Text txtStartingPoint;
	protected List lstDependentJavaFiles;
	protected List lstDependentLibFiles;
	protected Shell shell;
	protected Button btnBrowse;
	protected Button btnAdd1;
	protected Button btnAdd2;
	protected Button btnRemove1;
	protected Button btnRemove2;
	protected TabFolder tabFolder;
	
	protected SelectionListener selectionListener;
	
	protected boolean isPageValid = false;
	protected String errMsg = null;
	protected IPageContentsChangeListener listener = null;
	protected IProject project;
	
	public String[] getDependentJavaFiles() {
		return lstDependentJavaFiles.getItems();
	}

	public String[] getDependentLibraries() {
		return lstDependentLibFiles.getItems();
	}

	public String getStartingPoint() {
		return txtStartingPoint.getText();
	}

	public String validateStartingPoint(String startingPoint) {
		String returnValue = null;
		if(startingPoint != null && 
				startingPoint.trim().length() > 0){
			if(startingPoint.trim().toLowerCase().endsWith(".java")){
				File file = new File(startingPoint.trim());
				if(!file.exists()){
					returnValue = ScJaxWsResources.getString("error.JavaFileNotExist");
				}
			}else{
				returnValue = ScJaxWsResources.getString("error.InvalidJavaFile");
			}
		}else{
			returnValue = ScJaxWsResources.getString("error.EmptyJavaFile");
		}
		return returnValue;
	}

	public Control createContents(Composite parent) {
		shell = parent.getShell();
		GridData gridData = new GridData(GridData.FILL_BOTH);
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setLayoutData(gridData);
		composite.setLayout(new GridLayout(1, false));
		
		Group grpStartingPoint = new Group(composite, SWT.NONE);
		grpStartingPoint.setLayoutData(new GridData(GridData.FILL_HORIZONTAL | GridData.GRAB_HORIZONTAL));
		grpStartingPoint.setLayout(new GridLayout(3, false));
		
		new Label(grpStartingPoint, SWT.NONE).setText("Java Source File");
		txtStartingPoint = new Text(grpStartingPoint, SWT.BORDER);
		gridData = new GridData(GridData.FILL_HORIZONTAL);
		gridData.grabExcessHorizontalSpace = true;
		txtStartingPoint.setLayoutData(gridData);
		txtStartingPoint.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent event){
				validatePageContents();
			}
		});
		btnBrowse = new Button(grpStartingPoint, SWT.PUSH);
		btnBrowse.setText("Browse...");
		selectionListener = new SelectionAdapter(){
			public void widgetSelected(SelectionEvent se) {
				FileDialog dialog = new FileDialog(shell);
				dialog.setFilterExtensions(new String[]{"*.java"});
				dialog.setFilterPath(txtStartingPoint.getText());
				String selectedFile = dialog.open();
				if (selectedFile != null)
					txtStartingPoint.setText(selectedFile);
			}
		};
		btnBrowse.addSelectionListener(selectionListener);
		
		Group grpDependencies = new Group(composite, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		grpDependencies.setLayout(new GridLayout(1, false));
		grpDependencies.setLayoutData(gridData);
		grpDependencies.setText("Dependencies");
		
		tabFolder = new TabFolder(grpDependencies, SWT.UP);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		tabFolder.setLayoutData(gridData);
		TabItem tabItemJavaFiles = new TabItem(tabFolder, SWT.NONE);
		tabItemJavaFiles.setText("Java Files");
		TabItem tabItemLibFiles = new TabItem(tabFolder, SWT.NONE);
		tabItemLibFiles.setText("Libraries");
		
		//dependent java files tab item control
		Composite comJavaFiles = new Composite(tabFolder, SWT.NONE);
		tabItemJavaFiles.setControl(comJavaFiles);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;;
		comJavaFiles.setLayout(new GridLayout(2, false));
		comJavaFiles.setLayoutData(gridData);		
		
		lstDependentJavaFiles = new List(comJavaFiles, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL | SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		gridData.verticalSpan = 3;
		lstDependentJavaFiles.setLayoutData(gridData);
		
		btnAdd1 = new Button(comJavaFiles, SWT.PUSH);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		btnAdd1.setLayoutData(gridData);
		btnAdd1.setText("Add File(s)");
		btnAdd1.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent se) {
				FileDialog dialog = new FileDialog(shell, SWT.MULTI);
				dialog.setFilterExtensions(new String[]{"*.java"});
				dialog.setFilterPath(txtStartingPoint.getText());
				String selectedFile = dialog.open();
				if (selectedFile != null){
					String[] files = dialog.getFileNames();
					if(files != null && files.length > 0){
						for(String fileName: files){
							lstDependentJavaFiles.add(dialog.getFilterPath() + File.separator + fileName);
						}
					}
				}
			}
		});
		
		btnRemove1 = new Button(comJavaFiles, SWT.PUSH);
		btnRemove1.setText("Remove");
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		btnRemove1.setLayoutData(gridData);
		btnRemove1.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent se) {
				lstDependentJavaFiles.remove(lstDependentJavaFiles.getSelectionIndices());
			}
		});
		
		//dependent libraries tab item control
		Composite comLibFiles = new Composite(tabFolder, SWT.NONE);
		tabItemLibFiles.setControl(comLibFiles);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;;
		comLibFiles.setLayout(new GridLayout(2, false));
		comLibFiles.setLayoutData(gridData);		
		
		lstDependentLibFiles = new List(comLibFiles, SWT.MULTI | SWT.V_SCROLL | SWT.H_SCROLL | SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessVerticalSpace = true;
		gridData.grabExcessHorizontalSpace = true;
		gridData.verticalAlignment = GridData.FILL;
		gridData.verticalSpan = 3;
		lstDependentLibFiles.setLayoutData(gridData);
		
		btnAdd2 = new Button(comLibFiles, SWT.PUSH);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		btnAdd2.setLayoutData(gridData);
		btnAdd2.setText("Add Jar(s)");
		btnAdd2.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent se) {
				FileDialog dialog = new FileDialog(shell, SWT.MULTI);
				dialog.setFilterExtensions(new String[]{"*.jar"});
				dialog.setFilterPath(txtStartingPoint.getText());
				String selectedFile = dialog.open();
				if (selectedFile != null){
					String[] files = dialog.getFileNames();
					if(files != null && files.length > 0){
						for(String fileName: files){
							lstDependentLibFiles.add(dialog.getFilterPath() + File.separator + fileName);
						}
					}
				}
			}
		});
		
		btnRemove2 = new Button(comLibFiles, SWT.PUSH);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		btnRemove2.setText("Remove");
		btnRemove2.setLayoutData(gridData);
		btnRemove2.addSelectionListener(new SelectionAdapter(){
			public void widgetSelected(SelectionEvent se) {
				lstDependentLibFiles.remove(lstDependentLibFiles.getSelectionIndices());
			}
		});

		return composite;
	}

	public String getDescription() {
		return null;
	}

	public String getErrorMsg() {
		return errMsg;
	}

	public String getPageName() {
		return null;
	}

	public String getTitle() {
		return null;
	}

	public boolean isPageValid() {
		return isPageValid;
	}

	public void performFinish() {
		//do nothing
	}

	public void setChangeListener(IPageContentsChangeListener listener) {
		this.listener = listener;
	}

	public void setInitializationData(IConfigurationElement config,
			String propertyName, Object data) throws CoreException {
		// TODO Auto-generated method stub

	}
	
	public void setProject(IProject project){
		this.project = project;
	}
	
	private void validatePageContents(){
		errMsg = validateStartingPoint(txtStartingPoint.getText());
		if(errMsg == null){
			isPageValid = true;
		}else{
			isPageValid = false;
		}
		
		if(listener != null){
			listener.whenValidStatusChanged();
		}
	}
	
	public boolean getNeedAddWebMethodAnnotations(){
		return true;
	}

}
