/*******************************************************************************
* Copyright (c) 2006 IONA Technologies PLC
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
* 
* Contributors:
*     IONA Technologies PLC - initial API and implementation
*******************************************************************************/
package org.eclipse.stp.sc.jaxws.wizards.enablejaxws;

import org.eclipse.core.resources.IProject;
import org.eclipse.stp.common.logging.LoggingProxy;
import org.eclipse.stp.sc.jaxws.workspace.ScWsdlFirstNature;

public class WsdlFirstEnableWizard extends EnableWizardBase {
	
	private static final LoggingProxy LOG = LoggingProxy.getlogger(WsdlFirstEnableWizard.class);
	
	public WsdlFirstEnableWizard(IProject project){
		super(project);
	}
	
	public boolean performFinish(){
		try{
			super.performFinish();

			ScWsdlFirstNature.addToProject(project);
			
		}catch(Exception ex){
			LOG.error("error whilc enabling jaxws", ex);
			return false;
		}
		return true;
	}
}
