/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip.ServerSocketPool;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransport;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class TCPIPTransport
implements SessionTransport {
    private static final long MIN_TIMEOUT = 10000L;
    SessionAddress address;
    SessionAddress actual_address;
    public boolean initiator;
    public InputStream in;
    public OutputStream out;
    ServerSocket ssocket = null;
    public Socket socket = null;

    public TCPIPTransport(SessionAddress address, boolean initiator) throws Exception {
        this.address = address;
        this.initiator = initiator;
    }

    public boolean isAlive() {
        try {
            this.socket.getKeepAlive();
            return true;
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(this.initiator) + " DEAD");
            return false;
        }
    }

    public void tryReconnect() throws Exception {
        this.tryReconnect(0L);
    }

    public void tryReconnect(long timeout) throws Exception {
        this.voidActualAddress();
        try {
            this.socket.close();
            this.socket = null;
        }
        catch (Exception exception) {}
        if (this.initiator) {
            this.socket = new Socket(this.address.getListenerHost(), this.address.getListenerPortMinimum());
            int actual_port = this.socket.getLocalPort();
            this.createActualAddress(actual_port);
        } else {
            if (this.ssocket == null) {
                this.ssocket = this.address.getRequiresMultipleConnections() ? ServerSocketPool.getPooledServerSocket(this.address.getListenerPortMinimum()) : ServerSocketPool.getFreeServerSocket(this.address.getListenerPortMinimum(), this.address.getListenerPortMaximum());
            }
            int actual_port = this.ssocket.getLocalPort();
            this.createActualAddress(actual_port);
            if (timeout > 0L) {
                try {
                    this.ssocket.setSoTimeout(Math.max(10000, (int)timeout));
                }
                catch (Exception exception) {}
            }
            this.socket = this.ssocket.accept();
            if (this.actual_address != null) {
                this.actual_address.setInitiatorHost(this.socket.getInetAddress().getHostAddress());
            }
        }
        this.socket.setTcpNoDelay(true);
        this.socket.setKeepAlive(true);
        this.in = this.socket.getInputStream();
        this.out = this.socket.getOutputStream();
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (Exception exception) {}
        if (!this.address.getRequiresMultipleConnections()) {
            try {
                this.ssocket.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setSessionAddress(SessionAddress address) {
        this.address = address;
    }

    public boolean providesEncryption() {
        return false;
    }

    public boolean providesAuthentication() {
        return false;
    }

    public static int getMaxEncryptionStrengthBits() {
        return 0;
    }

    public int getEncryptionStrengthBits() {
        return 0;
    }

    public void setRequiredEncryptionStrengthBits(int bits) {
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    private void voidActualAddress() {
    }

    private void createActualAddress(int actual_port) {
        SessionAddress real_address = (SessionAddress)this.address.clone();
        if (this.initiator) {
            real_address.setInitiatorPortMinimum(actual_port);
            real_address.setInitiatorPortMaximum(actual_port);
        } else {
            real_address.setListenerPortMinimum(actual_port);
            real_address.setListenerPortMaximum(actual_port);
        }
        this.actual_address = real_address;
    }

    public SessionAddress getActualAddress() {
        return this.actual_address;
    }
}

