/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPNotFoundException;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPResponse;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPServer;
import org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.soap.http.HTTPUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.CharStack;
import org.eclipse.stp.b2j.core.jengine.internal.utils.StreamUtils;
import org.eclipse.stp.b2j.core.jengine.internal.utils.SyncCounter;

public class PortServer {
    private static final String RECEIVE_PREFIX = "RCV:";
    private static final String REPLY_PREFIX = "RPLY:";
    String protocol;
    int port;
    SimpleDateFormat sdf;
    SyncCounter open_connections = new SyncCounter();

    public PortServer(String protocol, int port) throws Exception {
        this.protocol = protocol;
        this.port = port;
        this.sdf = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
        this.sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        new AcceptThread(protocol, port).start();
    }

    private String getHtmlStackTrace(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        StringBuffer buf = new StringBuffer(os.toString());
        int index = buf.toString().indexOf("'\n");
        while (index != -1) {
            buf.insert(index + 1, "<br>");
            index = buf.toString().indexOf(10, index + 1);
        }
        index = buf.toString().indexOf(9);
        while (index != -1) {
            buf.replace(index, index + 1, "&nbsp;");
            index = buf.toString().indexOf(9, index + 1);
        }
        index = buf.toString().indexOf(32);
        while (index != -1) {
            buf.replace(index, index + 1, "&nbsp;");
            index = buf.toString().indexOf(32, index + 1);
        }
        return buf.toString();
    }

    class AcceptThread
    extends Thread {
        ServerSocket sock;

        public AcceptThread(String protocol, int port) throws Exception {
            this.setDaemon(true);
            if (protocol.equalsIgnoreCase("http")) {
                this.sock = new ServerSocket(port, 500);
            } else if (protocol.equalsIgnoreCase("https")) {
                try {
                    System.setProperty("javax.net.ssl.keyStore", "b2jkeystore");
                    System.setProperty("javax.net.ssl.keyStorePassword", "b2jb2jb2j");
                    Class[] c_empty = new Class[]{};
                    Object[] a_empty = new Object[]{};
                    Class<?> c_factory = Class.forName("javax.net.ssl.SSLServerSocketFactory");
                    Object o_factory = c_factory.getMethod("getDefault", c_empty).invoke(null, a_empty);
                    ServerSocket sslsock = (ServerSocket)c_factory.getMethod("createServerSocket", Integer.TYPE, Integer.TYPE).invoke(o_factory, new Integer(port), new Integer(500));
                    Class<?> c_sslsock = Class.forName("javax.net.ssl.SSLServerSocket");
                    String[] suites = (String[])c_sslsock.getMethod("getSupportedCipherSuites", c_empty).invoke((Object)sslsock, a_empty);
                    c_sslsock.getMethod("setEnabledCipherSuites", String[].class).invoke((Object)sslsock, new Object[]{suites});
                    c_sslsock.getMethod("setNeedClientAuth", Boolean.TYPE).invoke((Object)sslsock, Boolean.FALSE);
                    c_sslsock.getMethod("setWantClientAuth", Boolean.TYPE).invoke((Object)sslsock, Boolean.FALSE);
                    this.sock = sslsock;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Unable to load javax.net.ssl SSL classes for HTTPS support (" + e + ")");
                }
            }
        }

        public void run() {
            while (true) {
                try {
                    while (true) {
                        Socket s = this.sock.accept();
                        new SocketThread(s).start();
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    try {
                        Thread.sleep(5000L);
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                break;
            }
        }
    }

    class SocketThread
    extends Thread {
        Socket sock;

        public SocketThread(Socket s) {
            this.sock = s;
        }

        public void run() {
            PortServer.this.open_connections.add(1);
            System.out.println("PortServer - NEW CONNECTION " + PortServer.this.open_connections.getValue());
            try {
                BufferedInputStream bin = new BufferedInputStream(this.sock.getInputStream());
                HashMap<String, String> headers = new HashMap<String, String>();
                CharStack stack = null;
                boolean loop = true;
                while (loop) {
                    String tmp;
                    headers.clear();
                    String reqtype = null;
                    String version = null;
                    String resource = null;
                    String payload = null;
                    String response_code = null;
                    String response_errdetail = "";
                    HTTPResponse resp = new HTTPResponse();
                    boolean addKeepAliveHeader = false;
                    try {
                        String line = new String(StreamUtils.readLine(bin));
                        stack = new CharStack(line);
                        stack.popWhitespace();
                        reqtype = stack.popText(true);
                        stack.popWhitespace();
                        resource = stack.popText(true);
                        stack.popWhitespace();
                        version = stack.popText(true);
                        if (version.endsWith("1.1")) {
                            StringBuffer response_cont = new StringBuffer();
                            response_cont.append("HTTP/1.1 100 Continue\r\n\r\n");
                            this.sock.getOutputStream().write(response_cont.toString().getBytes());
                        }
                        String header = new String(StreamUtils.readLine(bin));
                        while (header.trim().length() > 0) {
                            int index = header.indexOf(58);
                            if (index >= 0) {
                                String key = header.substring(0, index).trim().toLowerCase();
                                String value = header.substring(index + 1);
                                headers.put(key, value);
                            }
                            header = new String(StreamUtils.readLine(bin));
                        }
                        String content_length = (String)headers.get("content-length");
                        if (content_length != null) {
                            int len = Integer.parseInt(content_length.trim());
                            payload = new String(StreamUtils.readBytes(bin, len));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        response_code = "500 Internal Server Error";
                        response_errdetail = PortServer.this.getHtmlStackTrace(e);
                    }
                    if (version.endsWith("1.1")) {
                        loop = true;
                        tmp = (String)headers.get("connection");
                        if (tmp != null && (tmp = tmp.trim()).equalsIgnoreCase("close")) {
                            loop = false;
                        }
                    } else if (version.endsWith("1.0")) {
                        loop = false;
                        tmp = (String)headers.get("connection");
                        if (tmp != null && (tmp = tmp.trim().toLowerCase()).startsWith("keep") && tmp.endsWith("alive")) {
                            loop = true;
                            addKeepAliveHeader = true;
                        }
                    } else {
                        loop = false;
                    }
                    try {
                        if (headers.get("transfer-encoding") != null) {
                            response_code = "501 Not Implemented";
                            response_errdetail = "This HTTP server does not currently support the HTTP Transfer-Encoding header";
                        } else if (!version.endsWith("1.0") && !version.endsWith("1.1")) {
                            response_code = "505 HTTP Version Not Supported";
                            response_errdetail = "This HTTP server supports only HTTP 1.0 and HTTP 1.1 (requested version was " + version + ")";
                        } else if (version.endsWith("1.1") && headers.get("host") == null) {
                            response_code = "400 Bad Request";
                            response_errdetail = "No 'Host: ' header received.  All HTTP 1.1 requests MUST contain a 'Host: ' header";
                        }
                        if (!(reqtype.equalsIgnoreCase("GET") || reqtype.equalsIgnoreCase("POST") || reqtype.equalsIgnoreCase("HEAD") || reqtype.equalsIgnoreCase("PUT"))) {
                            if (reqtype.equalsIgnoreCase("TRACE")) {
                                response_code = "501 Not Implemented";
                                response_errdetail = "This HTTP server does not support the TRACE method";
                            } else if (reqtype.equalsIgnoreCase("OPTIONS")) {
                                response_code = "501 Not Implemented";
                                response_errdetail = "This HTTP server does not support the OPTIONS method";
                            } else if (reqtype.equalsIgnoreCase("DELETE")) {
                                response_code = "501 Not Implemented";
                                response_errdetail = "This HTTP server does not support the DELETE method";
                            } else if (reqtype.equalsIgnoreCase("CONNECT")) {
                                response_code = "501 Not Implemented";
                                response_errdetail = "This HTTP server does not support the CONNECT method";
                            } else {
                                response_code = "501 Not Implemented";
                                response_errdetail = "HTTP method " + reqtype + " not recognised";
                            }
                        }
                        if (response_code == null) {
                            resp = HTTPServer.doRequest(PortServer.this.port, resource, payload, headers);
                            response_code = "200 OK";
                        }
                    }
                    catch (HTTPNotFoundException hTTPNotFoundException) {
                        response_code = "404 Not Found";
                    }
                    catch (HTTPException e) {
                        response_code = "500 Internal Server Error";
                        response_errdetail = PortServer.this.getHtmlStackTrace(e);
                    }
                    if (!response_code.startsWith("20") && resp.getSize() == 0) {
                        resp = new HTTPResponse(HTTPUtils.getHtmlError(response_code, response_errdetail));
                    }
                    StringBuffer response = new StringBuffer();
                    response.append(version);
                    response.append(" ");
                    response.append(response_code);
                    response.append("\r\n");
                    if (version.endsWith("1.1")) {
                        response.append(PortServer.this.sdf.format(new Date()));
                        response.append("\r\n");
                    }
                    if (addKeepAliveHeader) {
                        response.append("Connection: Keep-Alive");
                        response.append("\r\n");
                    }
                    if (resp.getSize() > 0) {
                        response.append("Content-Type: " + resp.getContentType());
                        response.append("\r\n");
                        response.append("Content-Length: " + resp.getSize());
                        response.append("\r\n");
                    } else {
                        response.append("Content-Length: 0");
                        response.append("\r\n");
                    }
                    response.append("\r\n");
                    byte[] sendDat = null;
                    if (!reqtype.equalsIgnoreCase("HEAD") && resp.getSize() > 0) {
                        sendDat = resp.getData();
                    }
                    byte[] responsedat = response.toString().getBytes();
                    this.sock.getOutputStream().write(responsedat);
                    if (sendDat != null) {
                        this.sock.getOutputStream().write(sendDat);
                    }
                    this.sock.getOutputStream().flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (Throwable x) {
                x.printStackTrace();
            }
            try {
                this.sock.close();
            }
            catch (Exception exception) {}
            PortServer.this.open_connections.subtract(1);
            System.out.println("PortServer - END CONNECTION " + PortServer.this.open_connections.getValue());
        }
    }
}

