/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.extensions.wsdlbinding.wsif.ports;

import org.eclipse.stp.b2j.core.jengine.internal.core.RunnerInterface;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedMutex;
import org.eclipse.stp.b2j.core.jengine.internal.core.sync.SharedSemaphore;
import org.eclipse.stp.b2j.core.jengine.internal.message.Message;

public class SynchronisationPort {
    public void newSemaphore(String name, int initial) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
        RunnerInterface engine = (RunnerInterface)thread;
        engine.newSemaphore(name, initial);
    }

    public void waitSemaphore(String name, int wait) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
        RunnerInterface engine = (RunnerInterface)thread;
        SharedSemaphore sem = engine.getSemaphore(name);
        sem.semWait(wait);
    }

    public void signalSemaphore(String name, int signal) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
        RunnerInterface engine = (RunnerInterface)thread;
        SharedSemaphore sem = engine.getSemaphore(name);
        sem.semSignal(signal);
    }

    public void newMutex(String name) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
        RunnerInterface engine = (RunnerInterface)thread;
        engine.newMutex(name);
    }

    public void lockMutex(String name) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
        RunnerInterface engine = (RunnerInterface)thread;
        SharedMutex mutex = engine.getMutex(name);
        mutex.lock();
    }

    public void releaseMutex(String name) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
        RunnerInterface engine = (RunnerInterface)thread;
        SharedMutex mutex = engine.getMutex(name);
        mutex.release();
    }

    public void newQueue(String name) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
    }

    public void addToQueue(String name, String value) throws Exception {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof RunnerInterface)) {
            throw new Exception("Unable to access synchronisation APIs");
        }
        RunnerInterface engine = (RunnerInterface)thread;
        Message m = new Message();
        m.append(value);
        engine.sendMessage("QueueSim:" + name, m);
    }

    public String getFromQueue(String name) throws Exception {
        Thread thread = Thread.currentThread();
        if (thread instanceof RunnerInterface) {
            RunnerInterface engine = (RunnerInterface)thread;
            Message m = engine.receiveMessage("QueueSim:" + name);
            return (String)m.get(0);
        }
        throw new Exception("Unable to access synchronisation APIs");
    }
}

