/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.b2j.core.jengine.internal.transport.session;

import org.eclipse.stp.b2j.core.jengine.internal.extensions.sessiontransport.tcpip.TCPIPTransportProvider;
import org.eclipse.stp.b2j.core.jengine.internal.transport.session.Session;
import org.eclipse.stp.b2j.core.misc.internal.B2jClassLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransport;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportLoader;
import org.eclipse.stp.b2j.core.publicapi.extension.sessiontransport.SessionTransportProvider;
import org.eclipse.stp.b2j.core.publicapi.transport.session.SessionAddress;

public class SessionFactory {
    public static Session newSession(SessionAddress address, boolean initiator) throws Exception {
        SessionTransport transport = null;
        SessionTransportProvider provider = null;
        if (address.getTransportProviderClassName() != null) {
            if (address.getTransportProviderClassName().length() > 0) {
                try {
                    SessionTransportProvider[] providers = SessionTransportLoader.getTransports();
                    int i = 0;
                    while (i < providers.length) {
                        if (providers[i].getProviderClassName().equals(address.getTransportProviderClassName())) {
                            provider = providers[i];
                            break;
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    provider = (SessionTransportProvider)B2jClassLoader.load(address.getTransportProviderClassName()).newInstance();
                }
            } else {
                provider = new TCPIPTransportProvider();
            }
        } else {
            provider = new TCPIPTransportProvider();
        }
        if (provider == null) {
            throw new Exception("Session transport provider [" + address.getTransportProviderClassName() + "] could not be loaded");
        }
        transport = provider.newInstance(address, initiator);
        if (address.getRequiresEncryption()) {
            if (!transport.providesEncryption()) {
                throw new Exception("Session requires encryption but specified transport does not support encryption");
            }
            if (address.getRequiresEncryptionStrengthBits() < transport.getEncryptionStrengthBits()) {
                throw new Exception("Session requires encryption but specified transport does not support encryption of required minimum strength");
            }
        }
        if (address.getRequiresAuthentication() && !transport.providesEncryption()) {
            throw new Exception("Session requires authentication but specified transport does not support authentication");
        }
        if (address.getRequiresMultipleConnections()) {
            if (address.getRequiresLinkReconnection()) {
                throw new Exception("Sessions that require multiple connections and link reconnection are not supported");
            }
            if (address.getListenerPortMinimum() != address.getListenerPortMaximum()) {
                throw new Exception("Sessions that require multiple connections and listen on a port range are not supported");
            }
        }
        Session session = new Session(address, transport);
        return session;
    }
}

